% Convolution example using a 2nd order Bessel-Thomson system and
% a 2nd-order Butterworth system - numerical example ;
% Analytical example : WBAmps_1.PDF (Part 1, Sec.1.14)
% Script.
% Call :         b2t2conv ;

% Author : E.Margan, 1989.09.16.
% No copyright protection applied !

[z1,p1]=bestap(2,'t');	% Bessel-Thomson 2nd-order system poles
 [z2,p2]=buttap(2);	% Butterworth 2nd-order system poles
 N=256;			% number of samples
 m=4;				% set the bandwidth factor
 w=(0:1:N-1)/m;		% frequency vector, w(m+1)=1 ;
 F1=freqw(p1,w);		% Bessel-Thomson system frequency response
 F2=freqw(p2,w);		% Butterworth system frequency response
 
 [S1,t]=tresp(F1,w,'s');% step-response of the Bessel-Thomson system,
 				% the normalized time vector is same for both.
 I2=tresp(F2,w,'u');	% unity-gain normalized Butterworth inpulse-resp.;
 d=max(find(t<=15));	% limit the plot to first 15 time units
 I2=I2(1:d);		% limit the I2 vector length to d
 
 	% convolution of Bessel-Thomson system step-response with
 	% the first d points of the Butterworth impulse response :
 y=vcon(I2,S1);
 
 % ***********************************************
 % NOTE : vector I2 was calculated to have a unity gain,
 % which means that the sum of all its elements is equal to 1,
 % consequently its amplitude is very low. To plot it on the
 % same vertical scale as the step response, we must artifficially
 % increase its amplitude N/(2*pi*m) times.
 % ***********************************************
 A=N/(2*pi*m);	% amplitude denormalization for I2
 	% plot first d points of all three responses vs. time :
 plot( t(1:d), S1(1:d), '-r',...
	 t(1:d), I2(1:d)*A, '-g',...
	 t(1:d),  y(1:d), '-b' )
 xlabel('Time [s]')

