function fig701
%FIG71	Generate Fig.7.1 - the convolution example for WBAmps, Part 7.
%
%	plot the 5th-order Butterworth impulse-response with a gated sinewave.

[z,p]=buttap(5);			% 5th-order Butterworth system
t=(0:1:300)/10;				% time vector
nt=length(t);

h=atdr(z,p,t(1:225),'i');	% system impulse-response
nh=length(h);

% figure(1);
% plot(t(1:nh),h)			% plot h vs t ;

b=25;							% switch-on delay 25 time-samples
T=2*pi/1.5;					% input signal frequency 1.5*(system hpbw)
								% make the input signal :
x=[zeros(1,b), sin(2*pi*t(1:nt-b)/T)];

								% plot h and x ;
% figure(2);
% plot( t(1:nh+b), [zeros(1,b), h], '-r', t, x, '-g')

y=vcon(h/sum(h),x);			% convolve x with h ;
								% h/sum(h) : normalize to unity gain

								% plot convolution result
figure(1);
plot( t, x, '-g', ...
      t(1:nh+b), [zeros(1,b), h],'-r', ...
      t, y(1:nt), '-b')
xlabel('Time [s]')
