function fig73(str)
%FIG73	Generate Fig.7.3. for WBAmps.
%	This is the 2-pole Butterworth, 2-pole Bessel system cascade example
%	from Part 1, generated with convolution.

% RXon, 000402

if ~nargin
	str='t';
end 
[z1,p1]=bestap(2,str);	% BesselThomson 2ndorder system poles
[z2,p2]=buttap(2);	% Butterworth 2ndorder system poles
N=256;
m=4;
w=(0:1:N-1)/m;		% frequency vector
F1=freqw(p1,w);		% BesselThomson system frequency response
F2=freqw(p2,w);		% Butterworth system frequency response

[S1,t]=tresp(F1,w,'s');	% step-response of the Bessel-Thomson system,
			% the normalized time vector is same for both.
I2=tresp(F2,w,'i');	% Butterworth inpulse-response;

d=round(3*N/5)-1;
I2=I2(1:d);		% limit the vector length;

% convolution of BesselThomson step response with the first 120 points
% of the Butterworth impulse response :
y=vcon(I2/sum(I2),S1);

			% plot all three responses versus time :
plot( t(1:d), S1(1:d), '-r', ...
      t(1:d), I2(1:d), '-g', ...
      t(1:d),  y(1:d), '-b' )
xlabel('Time [s]')
