function fig705
%FIG705	Generate Fig.7.5.x for the Part7 of the WBAmps.
%
%	This figures are for the system design example
%	n=[5,7,9].

% RXon, 000403

% ----------- frequency-domain analysis ----------------------- ;
N=601;      % number of freqency samples
A=2^12;		% ADC resolution limit sets the attenuation
fs=2e+7;    % ADC sampling frequency, 20MHz
fn=fs/2;	% ADC Nyquist frequency, 10MHz, = bandwidth requirement 
M=1e+6;     % MHz scale factor

f5=fn/(10^(log10(A^2-1)/(2*5)));
f7=fn/(10^(log10(A^2-1)/(2*7)));
f9=fn/(10^(log10(A^2-1)/(2*9)));
disp(' Asymptote cut-off frequencies' )
disp('     f5        f7       f9    [MHz]')
disp('-----------------------------------')
disp([f5, f7, f9]/M)

f=logspace(5,7,N);	% frequency (1e+5 to 1e+7 in 301 log-scale steps)
w=2*pi*f;

[z5,p5]=bestap(5,'a');	% BesselThomson 'asymptote' normalized systems
[z7,p7]=bestap(7,'a');	% of order 5, 7 and 9 ;
[z9,p9]=bestap(9,'a');

p5=p5*2*pi*f5;			% The poles are scaled-down so that all three
p7=p7*2*pi*f7;			% responses have 1/A attenuation at w=1e+6.
p9=p9*2*pi*f9;

F5=20*log10(abs(freqw(p5,w)));	% Calculate magnitudes in dB ;
F7=20*log10(abs(freqw(p7,w)));
F9=20*log10(abs(freqw(p9,w)));

figure(1)
% plot magnitudes in dB vs. log-scaled frequency
% and the -3dB reference level (see Fig.6.9) :
db3=-3.0103;
semilogx( f/M, F9, '-g', ...
          f/M, F5, '-r', ...
          f/M, F7, '-b', ...
          (fn/M)*[0.06, 0.3], [db3, db3], '-k', ...
          (fn/M)*[0.01, 1], 20*log10(1/A)*[1, 1], '--k' )
axh=gca;
% xlh=get(axh,'XLabel');
set(axh,'XTickLabelMode','manual');
set(axh,'XTickLabel',[' 0.1'; ' 1.0'; '10.0']);
xlabel( 'Frequency [MHz]' )
ylabel( 'Attenuation' )

text( (fn/M)*0.06, -6, '-3dB' )
text( (fn/M)*0.02, -70, 'ADC resolution : -72dB' )
text( (fn/M)*0.013, -25, 'Frequency-responses, normalized to' )
text( (fn/M)*0.013, -30, 'equal attenuation of -72dB at the' )
text( (fn/M)*0.013, -35, 'Nyquist frequency (10MHz)' )

% compare the magnitudes with the -3dB level and
% find the index of the frequency limits:

m=abs(F5-db3);
x5=find(m==min(m));

m=abs(F7-db3);
x7=find(m==min(m));

m=abs(F9-db3);
x9=find(m==min(m));

f5h=f(x5);
f7h=f(x7);
f9h=f(x9);
text( (fn/M)*0.013, -45, 'Cut-off frequencies :' )
text( (fn/M)*0.020, -50, ['f5 = ', num2str( round( f5h/1000 )/1000 ), ' MHz'])
text( (fn/M)*0.020, -55, ['f7 = ', num2str( round( f7h/1000 )/1000 ), ' MHz'])
text( (fn/M)*0.020, -60, ['f9 = ', num2str( round( f9h/1000 )/1000 ), ' MHz'])

% now display the cut-off frequencies :
disp('     f5h       f7h      f9h   [MHz]')
disp('-----------------------------------')
disp([f5, f7, f9]/M)


% ----------- time-domain analysis ---------------------------- ;
t=(0:1/(20*fs):1/M);	% time vector
xt=length(t);

S5=atdr(z5,p5,t,'s');	% Step responses
S7=atdr(z7,p7,t,'s');	% same time scale for all three responses
S9=atdr(z9,p9,t,'s');

figure(2)
% plot the step responses with the 0.1 and 0.9 reference levels :
ts=1e+5*t(1:xt);
x1=([0.10, 0.30]/M);
x2=([0.25, 0.55]/M);
y10=[.1 .1];
y90=[.9 .9];
plot(  t*M,  S9, '-g', ...
       t*M,  S5, '-r', ...
       t*M,  S7, '-b', ...
      x1*M, y10, '-k', ...
      x2*M, y90, '-k' )
xlabel( 'Time [us]' )
axis([0, max(t)*M, 0, 1.2]);
% text( 40, 0.70, 'Fig. 7.5.2.:' )
text( max(t)*M*0.05, 1.15, 'Step-responses of the denormalized' )
text( max(t)*M*0.05, 1.08, '9th-, 7th- and 5th-order systems' )
text( max(t)*M*0.5, 0.55, 'Rise-times :' )

x2=min(find(S5>=0.9));
x1=max(find(S5<=0.1));
Tr5=t(x2)-t(x1);
x2=min(find(S7>=0.9));
x1=max(find(S7<=0.1));
Tr7=t(x2)-t(x1);
x2=min(find(S9>=0.9));
x1=max(find(S9<=0.1));
Tr9=t(x2)-t(x1);
text( max(t)*M*0.5, 0.45, ['Tr9 = ', num2str(round(Tr9*1e+9)), ' ns'] )
text( max(t)*M*0.5, 0.38, ['Tr7 = ', num2str(round(Tr7*1e+9)), ' ns'] )
text( max(t)*M*0.5, 0.31, ['Tr5 = ', num2str(round(Tr5*1e+9)), ' ns'] )

% ----------- aliasing suppression analysis --------------- ;
% new frequency vector(1e+6 to 1e+8 in N log-scale steps)
f=logspace(6,8,N);
w=2*pi*f;
SF=1.75;					% frequency shift factor
F70=20*log10(abs(freqw(z7,p7,w)));	% reference system
F71=20*log10(abs(freqw(z7,SF*p7,w)));	% half-octave shifted system

xw0=max(find(F70>=-80));
xw1=max(find(F71>=-80));
xwa=max(find(F71>=-72));
xwn=find(f==fn);

fa=f(xwn:xwa);		% w0 <= w <= w(F71==1/A)
F71A=F71(xwn:xwa);	% F71 > Nyquist fr.
F71AF=F71(xwa:-1:xwn);	% alias of F71A ---------------- ???

fa2=[fa; fa];	% shadowing under F71A
fa2=fa2(:).';
[r,c]=size(F71A);
F71A2=[-72*ones(r,c); F71A];
F71A2=F71A2(:).';

faf=2*fn-fa;		% alias frequency vector

faf2=[faf; faf];	% shadowing of F71AF
faf2=faf2(:).';
F71AF2=[-72*ones(r,c); F71A];
F71AF2=F71AF2(:).';

Fr=20*log10(1/A)-F71A;	% aliasing filter requirement

figure(3);
semilogx(    f(1:xw0)/M,           F70(1:xw0), '-r' , ...
         [f(1), f(N)]/M, 20*log10(1/A)*[1, 1], '--k', ...
             f(1:xw1)/M,           F71(1:xw1), '-b' , ...
                  fa2/M,                F71A2, '-b' , ...
                 faf2/M,               F71AF2, '-g' , ...
                  faf/M,                 F71A, '-g' , ...
                  faf/M,                   Fr, '-m' )
axh=gca;
% xlh=get(axh,'XLabel');
set(axh,'XTickLabelMode','manual');
set(axh,'XTickLabel',[' 1.00'; ' 10.0'; '100.0']);
xlabel( 'Frequency [MHz]' )
ylabel( 'Attenuation' )
text(  3.0, -25, 'F7o' )
text(  5.3, -25, 'F7a' )
text(  8.0, -20, 'Frq' )
text( 15.0, -56, 'Fa' )
text(  3.3, -60, 'Fs-Fa' )
% text( 1.30, -5, 'Fig.7.5.3.: Alias band' )
% text( 1.30, -9, 'suppression requirement')
text( 5.0, -5, 'Alias band suppression requirement' )
