function fig712
%FIG712	Generate Fig.7.1.2 - the convolution example-2 for WBAmps, Part 7.
%
%	plot the 5th-order Butterworth response to the unit-step.

fh=1000;
[z,p]=buttap(5);		% 5th-order Butterworth system ;
p=2*pi*fh*p;				% denormalized poles
t=(0:1:300)/(50*fh);	% time vector, 20us delta-t, 6ms range
N=length(t);
% I=atdr(z,p,t,'i');		% impulse response, normalized to +1 gain
h=atdr(z,p,t,'n');		% impulse response, normalized to +1 gain

% --------- step-response test ---------------------------------------------
d=25;						% 25-sample switch-on delay
r=N-d;
h=h(1:r);	
x=[zeros(1,d) ones(1,r)];	% input unit-step function

y=vcon(h,x);			% convolve x with h ;

				% plot convolution result
A=N/(2*pi*fh*max(t));
%      t*fh, [zeros(1,d), I(1:r)/(2*pi*fh)],'.c', ...
plot( t*fh, x, '-g', ...
      t*fh, [zeros(1,d), h*A],'-r', ...
      t*fh, y(1:d+r), '-b' )
xlabel('Time [ms]')
