 function y=vcon(h,x)
 %VCON   Convolution, step-by-step example. See also CONV and FILTER.
 %	
 %	Call :	y=vcon(h,x);
 %	
 %	where:	x(t) --> the input signal
 %			h(t) --> the system impulse response
 %			y(t) --> the system response to x(t) by convolving
 %				   h(t) with x(t).
 %	If  length(x)=nx  and  length(h)=nh, then length(y)=nx+nh-1.

 %	Erik Margan, 890416,  Free of copyright !

				% force h to be the shorter vector :
 if length(h) > length(x)
	xx=x; x=h; h=xx;	% exchange x and h via xx;
	clear xx
 end
 nh=length(h);
 nx=length(x);
 h=h(:).';	% organize x and h as single-row vectors ;
 x=x(:).';

 y=zeros(2,nx+nh-1);	% form a (2)-by-(nx+nh-1) matrix y, all zeros
 y(1,1:nx)=h(1)*x;	% first row : multiply x by the first element of h
 for k=2:nh
				% second row : multiply and shift (insert 0):
	y(2, k-1:nx+k-1)=[0, h(k)*x];
				% sum the two rows column-wise and
				% put result back into first row :
	y(1,:)=sum(y);
 end				% repeat for all remaining elements of h ;
 y=y(1,:);			% the result is the first row only ;

