function coax(Zo,Co,len)
% COAX  COAXial cable transmission line design aid. 
%       Call :
%               cxtline( Zo, Co, len ) ;       
%       where:
%               Zo  <-- characteristic impedance []
%               Co  <-- capacitance per unit length [pF/m]
%               len <-- total cable length [m]

%       Erik Margan, 940502, 960923

% ---- constants : -----
mur = 1 ;                  % r
epsr = 1 ;                 % r
muo = pi*4e-7 ;            % o [Vs/Am]
epso = 8.85e-12 ;          % o [As/Vm]

Co = 1e-12 * Co ;

% ----- inductance/line_length : -----
Lo = Co * Zo^2 ;

% ----- propagation speed : -----
c = 1 / sqrt( muo * epso ) ;
% v = c / sqrt( epsr * mur ) ;
v = 1 / sqrt( Lo * Co ) ;

% ----- free-space impedance : -----
Zs = sqrt( muo / epso ) ;      % []

% total time delay :
Td = len / v ;       % [s]
Tr = len / c ;       % [s]

disp( '   Zo []    Co [pF]   Lo [nH]   len [m]   Td [ns]   ' ) ;
disp( '-----------------------------------------------------' ) ; 
if any( [ Zo - round( Zo ), Co*1e+12 - round( Co*1e+12 ), Lo*1e+9 - round( Lo*1e+9 ), len - round( len ), Td*1e+9 - round( Td*1e+9 ) ] )
        if any( [ Zo - 100, Co*1e+12 - 100, Lo*1e+9 - 100, len 100, Td*1e+9 - 100 ] )
                disp( round( [ Zo, Co*1e+12, Lo*1e+9, len, Td*1e+9 ] ) ) ;
        else
                disp( [ Zo+0.000001, Co*1e+12, Lo*1e+9, len, Td*1e+9 ] ) ;
        end
else
        disp( 3 )
        disp( [ Zo, Co*1e+12, Lo*1e+9, len, Td*1e+9 ] ) ;
end
disp( ' ' )

disp( '  v [mm/ns]  c [mm/ns]   ' ) ;
disp( '-------------------------' ) ;
disp( 1e-6*[ v, c ] ) ;
disp( ' ' ) ;

disp( '   Td [ns]   Tr [ns]   ' ) ;
disp( '-----------------------' ) ;
disp( 1e+9*[ Td, Tr ] ) ;

disp( ' ' )
disp( '   Zs []     ' ) ;
disp( '--------------' ) ;
disp( Zs )
disp( ' ' )

