function cxtline(l)
% CXTLINE ...CoaXial cable Transmission LINE design aid. 
%            A 100pF/m, 50 ohm coaxial cable is assumed.
%       Call :
%               cxtline(l);       
%       where:
%               l <-- total cable length [m]

%       Erik Margan, *940502*

if nargin == 0
        l=1;    % [m]
end

% constants :
mur=1;
mu0=pi*4e-7;            % [Vs/Am]
eps0=8.85e-12;          % [As/Vm]

Zo=50;          % [ohm]
Co=1e-10;         % [pF/m]

% inductance/line_length :
Lo=Co*Zo^2;

% propagation speed :
c=1/sqrt(mu0*eps0);
% v=c/sqrt(epsr*mur);
v=1/sqrt(Lo*Co);

% free-space impedance :
Zv=sqrt(mu0/eps0);      % [ohm]

% total time delay :
taut=l/v;       % [s]
tauv=l/c;       % [s]

disp(' ');
disp(['Line length l = ', num2str(l), ' [m]']);
disp(' ');

disp('   Zo [ohm]  Co [pF]   Lo [nH]   Zv [ohm]   ');
disp('--------------------------------------------');
disp([Zo, Co*1e+12, Lo*1e+9, Zv]);
disp(' ')

disp(' v [mm/ns]  c [mm/ns]  ');
disp('-----------------------');
disp(1e-6*[v, c]);
disp(' ');

disp(' taut [ns]  tauv [ns]  ');
disp('-----------------------');
disp(1e+9*[taut, tauv]);
