function H=Mag3d(Z,P,re,im,h,q)
%Mag3d	3-d system transfer function plot over s-plane.
%
%   Call : H=Mag3d(Z,P,re,im,h)
%
%	returns a 61-by-121 matrix of hights over s-plane points  and plots
%	the results as 3-d graph. s-plane is defined from 0 to "re" on real
%	axis and from "-im" to "+im" on imaginary axis, while "h" cutts the
%	results higher than "h"  for plot z-axis scaling. P and Z  describe
%	the system transfere function, P  being  a length-N vector  of pole
%	locations and Z is length-M vector of zero locations.
%
%	The shape of the ghaph  cutt along the imaginary axis at s=0 is the
%	magnitude of the system frequency response :
%
%	M(w) = abs(F(jw)) = sqrt( F(jw) .* F(-jw) )
%
%		Example :
%			[Z,P]=buttap(2);
%			H=Mag3d(Z,P,-3,3,3);
%
%	Optionally,	H=Mag3d(Z,P,re,im,h,res);      where res is the graph
%	resolution, will plot the [res+1, 2*res+1] matrix.
%
 
%	Erik Margan, Jan. 12-th, 1989
%	Jozef Stefan Institute, Ljubljana
%	No copyright protection applied !
%	Last revision : March 2nd, 1989
%	Matlab-IV rev.: 971105

if nargin < 6
	q = 1/60 ;
else
	q = 1/q ;
end

if nargin < 4
	im = abs( re ) ;
end
if nargin < 5
	h = max( abs( im ), abs( re ) ) ;
end

d = re * ( 0 : q/2 : 1 ) ;
w = im * ( 1 : -q : -1 ).' ;
m = max( size(d) ) ;
n = max( size(w) ) ;
H = ones( n, m ) ;

for k = 1 : m
	s = d(k) + sqrt(-1) * w ;
	if ( isempty( Z ) )
		H( :, k ) = abs( 1 ./ pats( P, s ) ) ;
	else
		H( :, k ) = abs( pats( Z, s ) ./ pats( P, s ) ) ;
	end
end

for k = 1 : m
	x = find( H( :, k ) > h ) ;
	if max( size(x) ) > 0
		H( x, k ) = h * ones( max( size(x) ), 1 ) ;
	end
end

B = figure( 1 ) ;
A = viewmtx( 50, 30, 0 ) ;
[ Xi, Yi ] = meshgrid( d, w ) ;
mesh( Xi, Yi, H )
view( A ), drawnow ;