function font_def( fontstr, fontsz )
% FONT_DEF	sets the 'TimesNewRoman' size 14 as the default plot font,
%		instead of the Matlab's original 'Helvetica'.
%		
%		Use :  at the start of a new Matlab session, possibly
%		inside STARTUP.M .  If a white background is desired,
%		call WHITEBG before FONT_DEF.
%		
%		Optionally, by entering the font-name string and a size number
%		as input arguments other default fonts can be installed.
%		
%		Example :	font_def( 'Courier New', 12 ) ;

%	Erik Margan, 981019.

if ~nargin
	fontstr = 'Times New Roman' ;
	fontsz = 14 ;
end

ch = get( 0, 'children' ) ;
if isempty( ch )
   fig = 0 ;
else
   fig = [ gcf 0 ] ;
end

set( fig, 'defaultaxesfontname', fontstr )
set( fig, 'defaultaxesfontsize', fontsz )

set( fig, 'defaultaxestickdir', 'out' )

set( fig, 'defaulttextfontname', fontstr )
set( fig, 'defaulttextfontsize', fontsz )

