function y=pats(P,s)
% PATS   Polynomial value AT S.
%	y = pats(P, s) returns the polynomial value at points set
%	by elements of s. The n-th degree polynomial is defined by
%	the vector P = [p1, p2,.., pn]  so that polynomial value is
%	zero for each element of P ( pn is the n-th root of P ). 
%	Values are calculated according to the formula :
%
%	y(s) = (s-p1)*(s-p2)*...*(s-pn) / (((-1)^n)*(p1*p2*...*pn))
%
%	The values are normalized so that y(0) = 1.
%	Complex  P and s  are used in  FREQW  to produce s-domain 
%	frequency response  H(s)  of the system  described by the
%	poles P.  

%	Erik Margan, November 10th, 1988
%	Jozef Stefan Institute, Ljubljana, Slovenia
%	Last revision : March 1st, 1989

[m,n]=size(s);
y=ones(m,n);
np=length(P);
for k=1:np
	if P(k) == 0
		y=y.*s;
	else
		y=y.*(s-P(k))/(-P(k));
	end
end
