function [tr,t10,t90]=risetime(z,p)
% RISETIME	returns the system risetime
%				(the time difference between the
%				 time at 90% and the time at 10%
%				 of the final amplitude).
%			Call :
%					[tr,t10,t90]=risetime(z,p);

% RXon, 011221

n=length(p);
w0=real(prod(-p)^(1/n));
tm=5/w0;
th=-gdly(z,p,0.01*w0);
t10=th/2;
y=atdr(z,p,t10);
while abs(y-0.1)>0.001
	t10=t10/sqrt(y/0.1);	
	y=atdr(z,p,t10);
end
t90=th*1.5;
y=atdr(z,p,t90);
while abs(y-0.9)>0.001
	t90=t90/sqrt(y/0.9);	
	y=atdr(z,p,t90);
end
tr=t90-t10;