function R=rsch(x0,y0,ds,lbl)
% RSCH ... Resistor circuit schematic plot.
%	     Used by "SCHEMA.M".
%	     Call :
%			R=rsch(x0,y0,ds,lbl) ;
%		
%		where:      R <-- returned end-point coordinates, R=[x0,y0,x1,y1] ;
%			x0,y0 --> starting coordinates
%			   ds --> direction string ( 'u', 'd', 'l', 'r' )
%			  lbl --> label, 'R' by default.

% RXon, 000625

RX1=[ 0, 2,   2.25,  2.75,  3.25,  3.75, 4.25, 4.75, 5, 7 ];
RY1=[ 0, 0,   0.5,  -0.5,   0.5,  -0.5,  0.5, -0.5,  0, 0 ];

if nargin < 4
	lbl = 'R' ;
end
if nargin < 3
	ds = 'r' ;
end

lblx = 3.0 ;
lbly = 1.0 ;

if strcmp(ds,'l')
	RX1=-RX1;
	lblx = -lblx ;
elseif strcmp(ds,'d')
	tmp=RX1;
	RX1=RY1;
	RY1=-tmp;
	tmp=lblx;
	lblx=lbly;
	lbly=-tmp;
elseif strcmp(ds,'u')
	tmp=RX1;
	RX1=RY1;
	RY1=tmp;
	tmp=lblx;
	lblx=lbly;
	lbly=tmp;
end

line(x0+RX1,y0+RY1,'Color',[0,0,0]);

R=[x0,y0,x0+RX1(max(size(RX1))),y0+RY1(max(size(RY1)))];
txh=text(x0+lblx,y0+lbly,lbl);
set(txh, 'VerticalAlignment','bottom');
