function gibbs(N)
% GIBBS		Gibb's effect for first N harmonic components.
%				
%				Call :		gibbs(N);
%				
%				where:		N --> the desired number of harmonics.

% RXon, 001004

t = ( -0.2 : 0.001 : 1.2 ) ;

y = zeros( 1, length(t) ) ;

for k = 1 : 2 : 2*N-1
	y = y + 4 * sin( 2 * pi * k * t ) / ( k * pi ) ;
end

plot( t, y ) ;
xlabel( 'Time [t/T]' ) ;
title( ['Summ of first ', num2str( k ), ' harmonics' ] ) ;
axis( [ min(t), max(t), -1.2, 1.2 ] ) ;
