function Hf=harmovie
% HARMOVIE	Harmonics Movie. Experimental.

% RXon, 001030

fig=figure;
set(fig,'DoubleBuffer','on');
set(gca,'xlim',[-80 80],'ylim',[-80 80],...
        'NextPlot','replace','Visible','off')

phi = 2*pi*(0:1/360:1);

w=(-8:1:8);

plot3([-1,1],[0,0],[0,0],'-k',...
      [0,0],[-8,8],[0,0],'-k',...
      [0,0],[0,0],[-1,1],'-k')
view( 30,20 );
hold on
k=1;
lh1=line([0,-sin(-phi(k))],[1,1],[0,-cos(-phi(k))]);
lh2=line([0,sin(phi(k))],[-1,-1],[0,cos(phi(k))]);
lh3=line([0,-sin(-3*phi(k))/3],[3,3],[0,-cos(-3*phi(k))/3]);
lh4=line([0,sin(3*phi(k))/3],[-3,-3],[0,cos(3*phi(k))/3]);
lh5=line([0,-sin(-5*phi(k))/5],[5,5],[0,-cos(-5*phi(k))/5]);
lh6=line([0,sin(5*phi(k))/5],[-5,-5],[0,cos(5*phi(k))/5]);
lh7=line([0,-sin(-7*phi(k))/7],[7,7],[0,-cos(-7*phi(k))/7]);
lh8=line([0,sin(7*phi(k))/7],[-7,-7],[0,cos(7*phi(k))/7]);
xlabel('Press any key...');
pause;
xlabel('                ');

if nargout
    Hf(k) = getframe ;
end


for k=2:length(phi)
	delete(lh1,lh2,lh3,lh4,lh5,lh6,lh7,lh8);
	lh1=line([0,-sin(-phi(k))],[1,1],[0,-cos(-phi(k))]);
	lh2=line([0,sin(phi(k))],[-1,-1],[0,cos(phi(k))]);
	lh3=line([0,-sin(-3*phi(k))/3],[3,3],[0,-cos(-3*phi(k))/3]);
	lh4=line([0,sin(3*phi(k))/3],[-3,-3],[0,cos(3*phi(k))/3]);
	lh5=line([0,-sin(-5*phi(k))/5],[5,5],[0,-cos(-5*phi(k))/5]);
	lh6=line([0,sin(5*phi(k))/5],[-5,-5],[0,cos(5*phi(k))/5]);
	lh7=line([0,-sin(-7*phi(k))/7],[7,7],[0,-cos(-7*phi(k))/7]);
	lh8=line([0,sin(7*phi(k))/7],[-7,-7],[0,cos(7*phi(k))/7]);
    pause(0.01);
	drawnow;
    if nargout
        Hf(k) = getframe ;
    end
end

if nargout
    movie2avi( Hf, 'harmdemo' );
end
