function inver_z(q)
% INVER_Z ... 3-D parametric plot of F(z)=1/z.

% RXon, 2000.05.23.

if ~nargin
	q=0;
end
M=3;
x=[0, logspace(-1,2,31)];
y=M*(-1:0.01:1);
for k = 1:length(x)
	F=1 ./(x(k)+j*y);
	for h=1:length(y)
		if imag(F(h)) > M
			F(h)=real(F(h))+j*M;
		end
		if imag(F(h)) < -M
			F(h)=real(F(h))-j*M;
		end
		if real(F(h)) > 2*M
			F(h)=2*M+j*imag(F(h));
		end
		% if real(F(h)) < -2*M
		%	F(h)=-2*M+j*imag(F(h));
		% end
	end
	if q
		plot3( 1 ./real(F), y, imag(F) );
	else
		plot3( real(F), y, imag(F) );
	end
	hold on
end
axis(M*[0,2,-1,1,-1,1]);
axis('square')
view(40,15);
grid
if q
	xlabel('1/\Re\{\itF\rm(\itz\rm)\} = (\itx\rm2 + \ity\rm2)/\itx')
else
	xlabel('\Re\{\itF\rm(\itz\rm)\} = \itx\rm/(\itx\rm2 + \ity\rm2)')
end
ylabel('\itj\rm\Im\{\itz\rm\} = \itjy')
zlabel('\itj\rm\Im\{\itF\rm(\itz\rm)\} = -\itjy\rm/(\itx\rm2 + \ity\rm2)')
title('\itF\rm(\itz\rm) = 1/\itz')
