function f263
% F263	Test WBA_2, Fig.2.6.3c frequency response.

% RXon, 20030607

z=[];
% Butterworth
pa=[-4.1213+j*1.7071;...
    -4.1213-j*1.7071;...
    -1.7071+j*4.1213;...
    -1.7071-j*4.1213;] ;
% Bessel
pb=[-2.8962+j*0.8672;...
    -2.8962-j*0.8672;...
    -2.1038+j*2.6574;...
    -2.1038-j*2.6574;] ;
% Group C
pc=[-3.3252+j*0.5863;...
    -3.3252-j*0.5863;...
    -1.7071+j*4.1213;...
    -1.7071-j*4.1213;] ;
% Group A
pd=[-3.8332+j*1.7874;...
    -3.8332-j*1.7874;...
    -2.1024+j*5.0013;...
    -2.1024-j*5.0013;] ;
% Reference
pr=-1;

w=logspace(-1,1,301);
Fa=freqw(z,pa,w);
Fb=freqw(z,pb,w);
Fc=freqw(z,pc,w);
Fd=freqw(z,pd,w);
Fr=freqw(z,pr,w);

loglog( w, abs(Fa), '-g',...
 w, abs(Fb), '-b',...
 w, abs(Fc), '-r',...
 w, abs(Fd), '-m',...
 w, abs(Fr), '-k');

axis([0.1,10,0.1,2]);
grid

