function txtr(K)
% TEST Transient response

% RXon, 010701

if ~nargin
	K=21;
end

t=0:0.01:10;

if K == 21
	% second-order series peaking Butterworth system :
	RC=1;
	m=1/2;
	s=-1/(2*m*RC);
	w=-s*sqrt(4*m-1);
	p=[s+j*w ; s-j*w]

	ar=atan(-w/s);
	% ar=angle(p(1));
	ad=ar*180/pi

%	g=1+(1/sin(ar))*exp(s*t).*sin(w*t-ar);
	g=1+(1/abs(sin(ar)))*exp(s*t).*sin(w*t+ar+pi);

%	h=1-sqrt(2)*exp(-t).*sin(t+0.7854);
	h=1+sqrt(2)*exp(-t).*sin(t+0.7854+pi);
	
	y=atdr([],p,t,'s');

	plot( t,g, t,h, t,y)
	title('2-pole Series-Peaking MFA System')
end

if K == 22
	% second-order series peaking Bessel-Thomson system :
	RC=1;
	m=1/3;
	s=-1/(2*m*RC);
	w=-s*sqrt(4*m-1);
	p=[s+j*w ; s-j*w]

	ar=atan(-w/s);
%	ar=angle(p(1));
	ad=ar*180/pi

%	g=1+(1/sin(ar))*exp(s*t).*sin(w*t-ar);
	g=1+(1/abs(sin(ar)))*exp(s*t).*sin(w*t+ar+pi);

%	h=1-2*exp(-1.5*t).*sin(0.866*t+0.524);
	h=1+2*exp(-1.5*t).*sin(0.866*t+0.524+pi);
	
	y=atdr([],p,t,'s');
	
	plot( t,g, t,h, t,y )
	title('2-pole Series-Peaking MFED System')
end

if K == 23
	% second-order series peaking Critical-Damping system :
	RC=1;
	m=1/4;
	s=-1/(2*m*RC);
	w=-s*sqrt(4*m-1);
	p=[s+j*w ; s-j*w]

%	ar=atan(-w/s);
%	ar=angle(p(1));
%	ad=ar*180/pi

	g=1+exp(s*t).*(s*t-1);

	h=1+exp(-2*t).*(-2*t-1);

	plot( t,g, t,h )
	title('2-pole Series-Peaking CD System')
end

if K == 30
	% general solution of third-order function !!!!!!!!!
	% third-order series peaking Butterworth system
	s1=-1;
	w1=sqrt(3);
	s2=-2;
	p=[s1+j*w1 ; s1-j*w1 ; s2] 

	A=(s1*s2*(s1-s2)-s2*w1^2)/(w1*((s1-s2)^2+w1^2));
	B=s2*(2*s1-s2)/((s1-s2)^2+w1^2);
	C=(s1^2+w1^2)/((s1-s2)^2+w1^2);

	% ar=angle(s1+j*w1)+angle((s1-s2)+j*w1)
	% ar=atan(w1/s1)+atan(w1/(s2-s1))
	ar=atan(-B/A);
	ad=ar*180/pi

	g=1-C*exp(s2*t);
	g=g-sqrt(A^2+B^2)*exp(s1*t).*sin(w1*t+ar);

	h=1-exp(-2*t)-1.155*exp(-t).*sin(sqrt(3)*t+0);

	y=atdr([],p,t,'s');

	plot( t,g, t,h, t,y )
	title('3-pole Series-Peaking MFA, general solution')
end

if K == 31
	% third-order series peaking Butterworth system
	s1=-1;
	w1=sqrt(3);
	s2=-2;
	p=[s1+j*w1 ; s1-j*w1 ; s2] 

	% ar=angle(s1+j*w1)+angle((s1-s2)+j*w1)
	ar=atan(w1/s1)+atan(w1/(s1-s2));
	ad=ar*180/pi

	g=1-((s1^2+w1^2)/((s1-s2)^2+w1^2))*exp(s2*t);
	g=g+(s2*sqrt(s1^2+w1^2)/(w1*sqrt((s1-s2)^2+w1^2)))*exp(s1*t).*sin(w1*t+ar);

	h=1-exp(-2*t)-1.155*exp(-t).*sin(sqrt(3)*t+0);

	y=atdr([],p,t,'s');

	plot( t,g, t,h, t,y )
	title('3-pole Series-Peaking MFA System')
end

if K == 32
	% third-order series peaking Bessel-Thomson system
	s1=-1.8389;
	w1=1.7544;
	s2=-2.3222;
	p=[s1+j*w1 ; s1-j*w1 ; s2]

	A=(s1*s2*(s1-s2)-s2*w1^2)/(w1*((s1-s2)^2+w1^2));
	B=s2*(2*s1-s2)/((s1-s2)^2+w1^2);
	C=(s1^2+w1^2)/((s1-s2)^2+w1^2);
	ar=atan(-B/A);
	ad=ar*180/pi
	y=1-C*exp(s2*t);
	y=y-sqrt(A^2+B^2)*exp(s1*t).*sin(w1*t+ar);

%	ar=angle(s1+j*w1)+angle((s1-s2)+j*w1)
%	ar=atan(w1/s1)+atan(w1/(s1-s2));
%	ad=ar*180/pi

%	((s1^2+w1^2)/((s1-s2)^2+w1^2))
%	(s2*sqrt(s1^2+w1^2)/(w1*sqrt((s1-s2)^2+w1^2)))
%	atan(- ???

	g=1-((s1^2+w1^2)/((s1-s2)^2+w1^2))*exp(s2*t);
	g=g+(s2*sqrt(s1^2+w1^2)/(w1*sqrt((s1-s2)^2+w1^2)))*exp(s1*t).*sin(w1*t+ar);

%	A1=(s2*sqrt(s1^2+w1^2)/(w1*sqrt((s1-s2)^2+w1^2)))
%	ar

	h=1-1.951*exp(-2.322*t)-1.849*exp(-1.839*t).*sin(1.754*t-0.540);
%	h=1-1.951*exp(-2.322*t)+1.849*exp(-1.839*t).*sin(1.754*t-0.540+pi);
%	OK, but not in agreement with the general relation !

	f=atdr([],p,t,'s');
	
	plot( t,g, t,h, t,0.5+1*(g-h), t,y, t,f )
	title('3-pole Series-Peaking MFED System')
end

if K == 33
	% third-order series peaking SPEC system
	s1=-0.75;
	w1=1.9848;
	s2=-1.5;
	p=[s1+j*w1 ; s1-j*w1 ; s2]

	% ar=atan(w1/s1)+atan(w1/(s1-s2));
	ar=angle(s1+j*w1)+angle((s1-s2)+j*w1);
	ad=ar*180/pi

	g=1-((s1^2+w1^2)/((s1-s2)^2+w1^2))*exp(s2*t);
	g=g-(s2*sqrt(s1^2+w1^2)/(w1*sqrt((s1-s2)^2+w1^2)))*exp(s1*t).*sin(w1*t-ar);

	h=1-exp(-1.5*t)-0.756*exp(-0.75*t).*sin(1.9848*t);
	
	plot(t,g,t,h,t,0.5+100*(g-h))
	title('3-pole Series-Peaking SPEC System')
end

if K == 41
	% second-order T-coil Butterworth system :
	t=t/2;
	RC=1;
	s=-2/RC;
	w=2;
	p=[s+j*w ; s-j*w]

	ar=atan(-w/s);
%	ar=angle(p(1));
	ad=ar*180/pi

%	g=1+(1/sin(ar))*exp(s*t).*sin(w*t-ar);
	g=1+(1/abs(sin(ar)))*exp(s*t).*sin(w*t+ar+pi);

%	h=1-sqrt(2)*exp(-2*t).*sin(2*t+0.785);
	h=1+sqrt(2)*exp(-2*t).*sin(2*t+0.785+pi);

	plot(t,g,t,h,t,0.5+100*(g-h))
	title('2-pole T-coil MFA System')
end

if K == 42
	% second-order T-coil Bessel-Thomson system :
	t=t/2;
	RC=1;
	s=-3/RC;
	w=sqrt(3);
	p=[s+j*w ; s-j*w]

	ar=atan(-w/s)
%	ar=angle(p(1));
	ad=ar*180/pi
	As=1/sin(ar)

%	g=1+(1/sin(ar))*exp(s*t).*sin(w*t-ar);
	g=1+(1/abs(sin(ar)))*exp(s*t).*sin(w*t+ar+pi);

%	h=1-2*exp(-3*t).*sin(sqrt(3)*t+0.524);
	h=1+2*exp(-3*t).*sin(sqrt(3)*t+0.524+pi);

	plot(t,g,t,h,t,0.5+(g-h))
	title('2-pole T-coil MFED System')
end

if K == 43
	% second-order T-coil CD system :
	t=t/2;
	RC=1;
	s=-4/RC;
	w=0;
	p=[s+j*w ; s-j*w]

	% a=atan(w/s);
	ar=angle(p(1));
	ad=ar*180/pi

	g=1+exp(s*t).*(s*t-1);

	h=1+exp(-4*t).*(-4*t-1);

	plot(t,g,t,h,t,0.5+100*(g-h))
	title('2-pole T-coil CD System')
end

if K == 44
	% second-order T-coil k=0 system :
	t=t/2;
	RC=1;
	s=-1/RC;
	w=sqrt(3);
	p=[s+j*w ; s-j*w]

	ar=atan(-w/s);
%	ar=angle(p(1));
	ad=ar*180/pi

%	g=1+(1/sin(ar))*exp(s*t).*sin(w*t-ar);
	g=1+(1/abs(sin(ar)))*exp(s*t).*sin(w*t+ar+pi);

%	h=1-(2/sqrt(3))*exp(-t).*sin(sqrt(3)*t+1.047);
	h=1+(2/sqrt(3))*exp(-t).*sin(sqrt(3)*t+1.047+pi);

	plot(t,g,t,h,t,0.5+100*(g-h))
	title('2-pole T-coil k=0 System')
end

if K == 51
	% third-order T-coil Butterworth system
	t=t/2;
	RC=1;
	s1=-3/(2*RC);
	w1=3*sqrt(3)/(2*RC);
	s2=-3/RC;
	p=[s1+j*w1 ; s1-j*w1 ; s2]

	% ar=atan(w1/s1)+atan(w1/(s1-s2));
	ar=angle(s1+j*w1)+angle((s1-s2)+j*w1);
	ad=ar*180/pi

	M=(s1^2+w1^2);
	N=(s1-s2);
	g=1;
	g=g-(s2*sqrt(M)/(w1*sqrt(N^2+w1^2)))*exp(s1*t).*sin(w1*t-ar);
	g=g-(M/(N^2+w1^2))*exp(s2*t);

	h=atdr([],p,t,'s');
	
	plot(t,g,t,h,t,0.5+100*(g-h))
	title('3-pole T-coil MFA System')
end

if K == 52
	% third-order T-coil Bessel-Thomson system
	t=t/2;
	RC=1;
	s1=-2.886/RC;
	w1=2.7532/RC;
	s2=-3.6447/RC;
	p=[s1+j*w1 ; s1-j*w1 ; s2]

	% ar=atan(w1/s1)+atan(w1/(s1-s2));
	ar=angle(s1+j*w1)+angle((s1-s2)+j*w1);
	ad=ar*180/pi

	M=(s1^2+w1^2);
	N=(s1-s2);
	g=1;
	g=g-(s2*sqrt(M)/(w1*sqrt(N^2+w1^2)))*exp(s1*t).*sin(w1*t-ar);
	g=g-(M/(N^2+w1^2))*exp(s2*t);

	h=atdr([],p,t,'s');
	
	plot(t,g,t,h,t,0.5+100*(g-h))
	title('3-pole T-coil MFED System')
end

if K == 53
	% third-order T-coil CD system
	t=t/2;
	RC=1;
	s1=-6/RC;
	w1=0;
	s2=-3/RC;
	p=[s1+j*w1 ; s1-j*w1 ; s2]

	% ar=atan(w1/s1)+atan(w1/(s1-s2));
	% ar=angle(s1+j*w1)+angle((s1-s2)+j*w1);
	% ad=ar*180/pi

	g=1;
	g=g-(s2/(s1-s2))*(s1*t+(s2-2*s1)/(s1-s2)).*exp(s1*t);
	g=g-(s1^2/(s2-s1)^2)*exp(s2*t);

%	h=1-exp(-6*t)-6*t.*exp(-3*t);    % wrong !!!!!!!
	h=1+3*(1+2*t).*exp(-6*t)-4*exp(-3*t);
	
%	plot(t,g,t,h,t,0.5+100*(g-h))
	plot(t,g,t,h,t,0.5+1*(g-h))
	title('3-pole T-coil CD System')
end

if K == 61
	% fourth-order L+T Butterworth system
	t=0.3*t;
	RC=1;
	s1=-4.1213/RC;
	w1=1.7071/RC;
	s2=-1.7071/RC;
	w2=4.1213/RC;
	p=[s1+j*w1 ; s1-j*w1 ; s2+j*w2 ; s2-j*w2]

%	K=(s1^2+w1^2)*(s2^2+w2^2);
%	A=w1*( (s1-s2)^2 - (w1^2-w2^2) + 2*s1*(s1-s2) ) ;
%	B=s1*( (s1-s2)^2 - (w1^2-w2^2) - 2*w1^2*(s1-s2) ) ;
%	ar1=angle(B+j*A);
%	ad1=ar1*180/pi
%	C=w2*( (s1-s2)^2 - (w1^2-w2^2) - 2*s1*(s1-s2) ) ;
%	D=s2*( (s1-s2)^2 - (w1^2-w2^2) + 2*w1*(s1-s2) ) ;
%	ar2=angle(D+j*C);
%	ad2=ar2*180/pi

	X=(s1^2+w1^2)*(s2^2+w2^2);
	A=w1*( (s1-s2)^2 - (w1^2-w2^2) + 2*s1*(s1-s2) ) ;
	B=s1*( (s1-s2)^2 - (w1^2-w2^2) ) - 2*w1^2*(s1-s2) ;
	% ar1=angle(B+j*A);
	ar1=atan(A/B);
	ad1=ar1*180/pi
	C=w2*( (s1-s2)^2 + (w1^2-w2^2) - 2*s2*(s1-s2) ) ;
	D=s2*( (s1-s2)^2 + (w1^2-w2^2) ) + 2*w2^2*(s1-s2) ;
	% ar2=angle(D+j*C);
	ar2=atan(C/D);
	ad2=ar2*180/pi

	g=1;
	g=g-(X/(w1*sqrt(A^2+B^2)))*exp(s1*t).*sin(w1*t-ar1);
	g=g-(X/(w2*sqrt(C^2+D^2)))*exp(s2*t).*sin(w2*t-ar2);

	h=1;
	h=h-2.4142*exp(-4.1213*t).*sin(1.7071*t+0.9956);
	h=h+0.9968*exp(-1.7071*t).*sin(4.1213*t-0.9956);

	f=atdr([],p,t,'s');
	
	plot(t,g, t,h, t,0.5+1*(g-h), t,f)
	title('4-pole L+T MFA System')
end

if K == 62
	% fourth-order L+T Bessel-Thomson system
	t=0.3*t;
	RC=1;
	s1=-4.7317/RC;
	w1=1.4167/RC;
	s2=-3.4376/RC;
	w2=4.3419/RC;
	p=[s1+j*w1 ; s1-j*w1 ; s2+j*w2 ; s2-j*w2]

%	K=( s1^2 + w1^2 ) * ( s2^2 + w2^2 ) ;
%	A=w1*( (s1-s2)^2 - ( w1^2 - w2^2 ) - 2*s1*(s1-s2) ) ;
%	B=s1*( (s1-s2)^2 - ( w1^2 - w2^2 ) - 2*w1^2*(s1-s2) ) ;
%	C=w2*( (s1-s2)^2 - ( w1^2 - w2^2 ) - 2*s2*(s1-s2) ) ;
%	D=s2*( (s1-s2)^2 - ( w1^2 - w2^2 ) - 2*w2^2*(s1-s2) ) ;
%	ar1=angle(B+j*A);
%	ad1=ar1*180/pi
%	ar2=angle(D+j*C);
%	ad2=ar2*180/pi

	X=(s1^2+w1^2)*(s2^2+w2^2);
	A=w1*( (s1-s2)^2 - (w1^2-w2^2) + 2*s1*(s1-s2) ) ;
	B=s1*( (s1-s2)^2 - (w1^2-w2^2) ) - 2*w1^2*(s1-s2) ;
%	ar1=angle(B+j*A);
	ar1=atan(A/B);
	ad1=ar1*180/pi
	C=w2*( (s1-s2)^2 + (w1^2-w2^2) - 2*s2*(s1-s2) ) ;
	D=s2*( (s1-s2)^2 + (w1^2-w2^2) ) + 2*w2^2*(s1-s2) ;
%	ar2=angle(D+j*C);
	ar2=atan(C/D);
	ad2=ar2*180/pi

	g=1;
	g=g-(X/(w1*sqrt(A^2+B^2)))*exp(s1*t).*sin(w1*t-ar1);
	g=g-(X/(w2*sqrt(C^2+D^2)))*exp(s2*t).*sin(w2*t-ar2);


	h=1-5.6632*exp(-4.7317*t).*sin(1.4167*t+0.4866);
	h=h+1.6484*exp(-3.4376*t).*sin(4.3419*t+1.5389);
	
	f=atdr([],p,t,'s');

	plot(t,g, t,h, t,0.5+1*(g-h), t,f)
	title('4-pole L+T MFED System')
end

% 7x - 2-pole shunt

% 8x - 3-pole shunt

% 9x - shunt-series (4-pole, 1-zero)
if K == 91
	% MFA (Shea) shunt-series (4-pole, 1-zero)
	% poles
	s1 =-2.4042;
	w1 =1.0053;
	s2 =-0.9971;
	w2 =2.4161;

	% zero
	s3 =-6.8027;

	p=[s1+j*w1; s1-j*w1; s2+j*w2; s2-j*w2];
	z=s3; 

	X=(s1^2+w1^2)*(s2^2+w2^2)/s3;
	A=w1*( (s1-s2)^2 - (w1^2-w2^2) + 2*s1*(s1-s2) );
	B=s1*( (s1-s2)^2 - (w1^2-w2^2) ) - 2*w1^2*(s1-s2);
	C=s3-s1;
	D=w2*( (s1-s2)^2 + (w1^2-w2^2) + 2*s2*(s1-s2) );
	E=s2*( (s1-s2)^2 + (w1^2-w2^2) ) - 2*w2^2*(s1-s2);
	F=s3-s2;
	ar1=atan( (A*C + B*w1)/(B*C - A*w1) );
	ar2=atan( (D*F + E*w2)/(E*F - D*w2) );
	ad1=ar1*180/pi
	ad2=ar2*180/pi

	g=1;
	g=g+( (X*sqrt( (A*C+B*w1)^2 + (B*C-A*w1)^2) )/(w1*(A^2+B^2) ) )*exp(s1*t).*sin(w1*t-ar1);
	g=g+( (X*sqrt((D*F+E*w2)^2 + (E*F-D*w2)^2))/(w2*(D^2+E^2) ) )*exp(s2*t).*sin(w2*t+ar2);

	% f=atdr(z,p,t,'s');
	f=(0:1:255)/6;
	Y=freqw(z,p,f);
	[y,tt]=tresp(Y,f,'s');
	tx=min(find(tt>=max(t)))-1;

	plot( t,g, tt(1:tx),y(1:tx) );
	title( '4-pole, 1-zero shunt-series MFA (Shea)')
end
if K == 92
	% SPEC (Braude) shunt-series (4-pole, 1-zero)
	% poles, two real
	s1 = -1.9693;
	w1 =  2.0491;
	s2 = -3.0101;
	s3 = -5.5512;

	% zero
	s4 = -12.5000;

	p=[s1+j*w1; s1-j*w1; s2; s3];
	z=s4; 

	X=(s1^2+w1^2)*w1*s2/s3
% ??????????????????????????????????
X=0.487*(s1^2+w1^2)*w1*s2*s3/s4
% ??????????????????????????????????

	A=w1*( (s2-s1)*(s3-s1) - w1^2 - s1*(s2+s3-2*s1) )
	B=s1*(s2-s1)*(s3-s1) + w1^2*(s2+s3-3*s1)
	C=s4-s1
	D=s4-s2
	E=s2*(s2-s3)*( (s1-s2)^2 + w1^2 )
	F=s4-s3
	G=s3*(s3-s2)*( (s1-s3)^2 +w1^2 )

	an=(A*C + B*w1)
	ad=(-B*C + A*w1)
	aq=(A*C + B*w1)/(-B*C + A*w1)

	ar1=atan( (A*C + B*w1)/(-B*C + A*w1) );
	ad1=ar1*180/pi

	g=( X * sqrt( (A*C-B*w1)^2 + (B*C+A*w1)^2 ) );
	g=g/( w1 * (A^2+B^2) );
	g=g * exp(s1*t).*sin( w1*t + ar1 );
	g=g + 1;
	g=g + ( X*D/E )*exp(s2*t) ;
	g=g + ( X*F/G )*exp(s3*t);

	% f=atdr(z,p,t,'s');
	f=(0:1:255)/2;
	Y=freqw(z,p,f);
	[y,tt]=tresp(Y,f,'s');
	tx=min(find(tt>=max(t)))-1;

	plot( t,g, tt(1:tx),y(1:tx) );
	title( '4-pole, 1-zero shunt-series SPEC (Braude)')
end
