function tztry(X,pi_flag)
% TEST Transient response of
% Wideband Amplifiers Part-2 Inductive-Peaking Circuits
% The problem of +/-pi/2 periode of atan() function
% is being tentatively soved by taking poles from
% the third qouadrant, so that w and s have the same sign.
% This has been implemented by inverting w after z and p
% have been defined. The pi addition was elliminated.
% the option is implemented by calling the function with
% two arguments, the second being any non-zero number.
%
%
% WARNING :  The attempt has failed !!!!!!!!!!!!!
%            RXon, 020109

% RXon, 010923

if nargin < 2
	pi_flag = 1 ;
end
if ~nargin
	X = 21 ;
end

t=0:0.01:10;

if X == 21
	% 2nd-order series peaking MFA system :
	RC=1;
	m=1/2;
	s=-1/(2*m*RC);
	w=-s*sqrt(4*m-1);
	p=[s+j*w ; s-j*w]
	if pi_flag
		w=-w ;
	end
	
	ar=atan(-w/s);
	ad=ar*180/pi
	
%	g=1+(1/sin(ar))*exp(s*t).*sin(w*t-ar);
	if pi_flag
		g=1+(1/abs(sin(ar)))*exp(s*t).*sin(w*t+ar);
	else
		g=1+(1/abs(sin(ar)))*exp(s*t).*sin(w*t+ar+pi);
	end
	
	if pi_flag
		h=1-sqrt(2)*exp(-t).*sin(t+0.7854);
	else
		h=1+sqrt(2)*exp(-t).*sin(t+0.7854+pi);
	end
	
	y=atdr([],p,t,'s');
	
	plot( t,g, t,h+0.01, t,y+0.02)
	title('2-pole Series-Peaking MFA System')
end

if X == 22
	% 2nd-order series peaking MFED system :
	RC=1;
	m=1/3;
	s=-1/(2*m*RC);
	w=-s*sqrt(4*m-1);
	p=[s+j*w ; s-j*w]
	if pi_flag
		w=-w ;
	end
	
	ar=atan(-w/s);
	ad=ar*180/pi
	
%	g=1+(1/sin(ar))*exp(s*t).*sin(w*t-ar);
	if pi_flag
		g=1+(1/abs(sin(ar)))*exp(s*t).*sin(w*t+ar);
	else
		g=1+(1/abs(sin(ar)))*exp(s*t).*sin(w*t+ar+pi);
	end
	
	if pi_flag
		h=1+2*exp(-1.5*t).*sin(-0.866*t-0.524);
	else
		h=1+2*exp(-1.5*t).*sin(0.866*t+0.524+pi);
	end
	
	y=atdr([],p,t,'s');
	
	plot( t,g, t,h+0.01, t,y+0.02 )
	title('2-pole Series-Peaking MFED System')
end

if X == 23
	% 2nd-order series peaking Critical-Damping system :
	RC=1;
	m=1/4;
	s=-1/(2*m*RC);
	w=-s*sqrt(4*m-1);
	p=[s+j*w ; s-j*w]
	if pi_flag
		w=-w ;		% w = 0 , no change !
	end
	
	g=1+exp(s*t).*(s*t-1);
	
	h=1+exp(-2*t).*(-2*t-1);
	
	plot( t,g, t,h+0.01 )
	title('2-pole Series-Peaking CD System')
end

if X == 31
	% general solution of third-order function !!!!!!!!!
	% 3rd-order series peaking MFA system
	s1=-1;
	w1=sqrt(3);
	s2=-2;
	p=[s1+j*w1 ; s1-j*w1 ; s2] 
	if pi_flag
		w1=-w1 ;
	end
	
	A=s1*(s1-s2)-w1^2;
	B=2*s1-s2;
	C=(s1-s2)^2+w1^2;
	
	ar=atan(-w1*B/A);
	ad=ar*180/pi
	
	if pi_flag
		g=1-(s2/(w1*C))*sqrt(A^2+w1^2*B^2)*exp(s1*t).*sin(w1*t+ar);
	else
		g=1-(s2/(w1*C))*sqrt(A^2+w1^2*B^2)*exp(s1*t).*sin(w1*t+ar+pi);
	end
	g=g-((s1^2+w1^2)/C)*exp(s2*t);
	
%	(s2/(w1*C))*sqrt(A^2+w1^2*B^2) % = -1.1547
%	((s1^2+w1^2)/C)                % = +1
	
	if pi_flag
		h=1-1.155*exp(-t).*sin(sqrt(3)*t+0)-exp(-2*t);
	else
		h=1+1.155*exp(-t).*sin(sqrt(3)*t+0+pi)-exp(-2*t);
	end
	
	y=atdr([],p,t,'s');
	
	plot( t,g, t,h+0.01, t,y+0.02 )
	title('3-pole Series-Peaking MFA, general solution')
end

if X == 32
	% 3rd-order series-peaking MFED system
	s1=-1.8389;
	w1=1.7544;
	s2=-2.3222;
	p=[s1+j*w1 ; s1-j*w1 ; s2]
	if pi_flag
		w1=-w1 ;
	end
	
	A=s1*(s1-s2)-w1^2;
	B=2*s1-s2;
	C=(s1-s2)^2+w1^2;
	
	ar=atan(-w1*B/A)
	ad=ar*180/pi
	
	if pi_flag
		g=1-(s2/(w1*C))*sqrt(A^2+w1^2*B^2)*exp(s1*t).*sin(w1*t+ar);
	else
		g=1-(s2/(w1*C))*sqrt(A^2+w1^2*B^2)*exp(s1*t).*sin(w1*t+ar+pi);
	end
	g=g-((s1^2+w1^2)/C)*exp(s2*t);
	
%	(s2/(w1*C))*sqrt(A^2+w1^2*B^2) % = -1.8487
%	((s1^2+w1^2)/C)                % = +1.9506
	
	if pi_flag
		h=1+1.849*exp(-1.839*t).*sin(1.754*t-0.540)-1.951*exp(-2.322*t);
	else
		h=1+1.849*exp(-1.839*t).*sin(1.754*t-0.540+pi)-1.951*exp(-2.322*t);
	end
	
	y=atdr([],p,t,'s');
	
	plot( t,g, t,h+0.01, t,y+0.02 )
	title('3-pole Series-Peaking MFED System')
end

if X == 33
	% third-order series peaking SPEC system
	s1=-0.75;
	w1=1.9848;
	s2=-1.5;
	p=[s1+j*w1 ; s1-j*w1 ; s2]
	if pi_flag
		w1=-w1 ;
	end
	
	A=s1*(s1-s2)-w1^2;
	B=2*s1-s2;
	C=(s1-s2)^2+w1^2;
	
	ar=atan(-w1*B/A)
	ad=ar*180/pi
	
	if pi_flag
		g=1-(s2/(w1*C))*sqrt(A^2+w1^2*B^2)*exp(s1*t).*sin(w1*t+ar);
	else
		g=1-(s2/(w1*C))*sqrt(A^2+w1^2*B^2)*exp(s1*t).*sin(w1*t+ar+pi);
	end
	g=g-((s1^2+w1^2)/C)*exp(s2*t);
	
%	(s2/(w1*C))*sqrt(A^2+w1^2*B^2) % = -0.7557
%	((s1^2+w1^2)/C)                % = +1
	
	if pi_flag
		h=1+0.756*exp(-0.75*t).*sin(1.9848*t+0)-exp(-1.5*t);
	else
		h=1+0.756*exp(-0.75*t).*sin(1.9848*t+0+pi)-exp(-1.5*t);
	end
	
	y=atdr([],p,t,'s');
	
	plot( t,g, t,h+0.01, t,y+0.02 )
	title('3-pole Series-Peaking SPEC System')
end

if X == 34
	% 3rd-order series peaking CD system
	% will not be included in the book !!!
	s1=-3;
	w1=0;
	s2=-1.5;
	p=[s1+j*w1 ; s1-j*w1 ; s2]
	if pi_flag
		w1=-w1 ;		% w = 0, no change
	end
	
%	g=1+(s2/((s2-s1)^2))*(-s1^2*t+s1*(s2*t+2)-s2).*exp(s1*t);
	g=1+(s2^2/((s2-s1)^2))*(((s2-s1)*s1/s2)*t+2*s1/s2-1).*exp(s1*t);
	g=g-(s1^2/((s2-s1)^2))*exp(s2*t);
%	(s2^2/((s2-s1)^2)) % = 1
%	(s2-s1)*s1/s2		% = 3
%	(2*s1/s2-1)			% = 3
%	(s1^2/((s2-s1)^2))	% = 4
	
	h=1+(3*t+3).*exp(-3*t)-4*exp(-1.5*t); % ????????????????
	
	plot( t,g, t,h+0.01 )
	title('3-pole Series-Peaking CD System')
end

if X == 41
	% 2nd-order T-coil MFA system :
	t=t/2;
	RC=1;
	s=-2/RC;
	w=2;
	p=[s+j*w ; s-j*w]
	if pi_flag
		w=-w ;
	end
	
	ar=atan(-w/s);
%	ar=angle(p(1));
	ad=ar*180/pi
	
%	g=1+(1/sin(ar))*exp(s*t).*sin(w*t-ar);
	if pi_flag
		g=1+(1/abs(sin(ar)))*exp(s*t).*sin(w*t+ar);
	else
		g=1+(1/abs(sin(ar)))*exp(s*t).*sin(w*t+ar+pi);
	end
	
	if pi_flag
		h=1-sqrt(2)*exp(-2*t).*sin(2*t+0.785);
	else
		h=1+sqrt(2)*exp(-2*t).*sin(2*t+0.785+pi);
	end
	
	y=atdr([],p,t,'s');
	
	plot( t,g, t,h+0.01, t,y+0.02 )
	title('2-pole T-coil MFA System')
end

if X == 42
	% 2nd-order T-coil MFED system :
	t=t/2;
	RC=1;
	s=-3/RC;
	w=sqrt(3);
	p=[s+j*w ; s-j*w]
	if pi_flag
		w=-w ;
	end
	
	ar=atan(-w/s)
%	ar=angle(p(1));
	ad=ar*180/pi
	As=1/sin(ar)
	
%	g=1+(1/sin(ar))*exp(s*t).*sin(w*t-ar);
	if pi_flag
		g=1+(1/abs(sin(ar)))*exp(s*t).*sin(w*t+ar);
	else
		g=1+(1/abs(sin(ar)))*exp(s*t).*sin(w*t+ar+pi);
	end
	
	if pi_flag
		h=1-2*exp(-3*t).*sin(sqrt(3)*t+0.524);
	else
		h=1+2*exp(-3*t).*sin(sqrt(3)*t+0.5236+pi);
	end
	
	y=atdr([],p,t,'s');
	
	plot( t,g, t,h+0.01, t,y+0.02 )
	title('2-pole T-coil MFED System')
end

if X == 43
	% 2nd-order T-coil CD system :
	t=t/2;
	RC=1;
	s=-4/RC;
	w=0;
	p=[s+j*w ; s-j*w]
	if pi_flag
		w=-w ;		% w = 0, no change
	end
	
	g=1+exp(s*t).*(s*t-1);
	
	h=1+exp(-4*t).*(-4*t-1);
	
	plot( t,g, t,h+0.01 )
	title('2-pole T-coil CD System')
end

if X == 44
	% 2nd-order T-coil k=0 system :
	t=t/2;
	RC=1;
	s=-1/RC;
	w=sqrt(3);
	p=[s+j*w ; s-j*w]
	if pi_flag
		w=-w ;
	end
	
	ar=atan(-w/s);
%	ar=angle(p(1));
	ad=ar*180/pi
	
%	g=1+(1/sin(ar))*exp(s*t).*sin(w*t-ar);
	if pi_flag
		g=1+(1/abs(sin(ar)))*exp(s*t).*sin(w*t+ar);
	else
		g=1+(1/abs(sin(ar)))*exp(s*t).*sin(w*t+ar+pi);
	end
	
	if pi_flag
		h=1-(2/sqrt(3))*exp(-t).*sin(sqrt(3)*t+1.047);
	else
		h=1+(2/sqrt(3))*exp(-t).*sin(sqrt(3)*t+1.047+pi);
	end
	
	y=atdr([],p,t,'s');
	
	plot( t,g, t,h+0.01, t,y+0.02 )
	title('2-pole T-coil k=0 System')
end

if X == 51
	% 3rd-order T-coil MFA system
	t=t/2;
	RC=1;
	s1=-3/(2*RC);
	w1=3*sqrt(3)/(2*RC);
	s2=-3/RC;
	p=[s1+j*w1 ; s1-j*w1 ; s2]
	if pi_flag
		w1=-w1 ;
	end
	
	ar=atan(w1/s1)+atan(w1/(s1-s2));
	ad=ar*180/pi
	
	M=(s1^2+w1^2);
	N=(s1-s2);
	g=1;
	if pi_flag
		g=g-(s2*sqrt(M)/(w1*sqrt(N^2+w1^2)))*exp(s1*t).*sin(w1*t+ar);
	else
		g=g-(s2*sqrt(M)/(w1*sqrt(N^2+w1^2)))*exp(s1*t).*sin(w1*t+ar+pi);
	end
	g=g-(M/(N^2+w1^2))*exp(s2*t);
%	(s2*sqrt(M)/(w1*sqrt(N^2+w1^2)))
%	sin(ar+pi)
%	(M/(N^2+w1^2))
	
	if pi_flag
		h=1+1.1547*exp(-1.5*t).*sin(2.5981*t+0);
	else
		h=1+1.1547*exp(-1.5*t).*sin(2.5981*t+0+pi);
	end
	h=h-exp(-3*t);
	
	y=atdr([],p,t,'s');
	
	plot( t,g, t,h+0.01, t,y+0.02 )
	title('3-pole T-coil MFA System')
end

if X == 52
	% 3rd-order T-coil MFED system
	t=t/2;
	RC=1;
	s1=-2.886/RC;
	w1=2.7532/RC;
	s2=-3.6447/RC;
	p=[s1+j*w1 ; s1-j*w1 ; s2]
	if pi_flag
		w1=-w1 ;
	end
		
	A=s1*(s1-s2)-w1^2;
	B=2*s1-s2;
	C=(s1-s2)^2+w1^2;
	
	ar=atan(-w1*B/A)
	ad=ar*180/pi
	
	if pi_flag
		g=1-(s2/(w1*C))*sqrt(A^2+w1^2*B^2)*exp(s1*t).*sin(w1*t+ar);
	else
		g=1-(s2/(w1*C))*sqrt(A^2+w1^2*B^2)*exp(s1*t).*sin(w1*t+ar+pi);
	end
	g=g-((s1^2+w1^2)/C)*exp(s2*t);
	
%	(s2/(w1*C))*sqrt(A^2+w1^2*B^2) % = -1.8489
%	((s1^2+w1^2)/C)                % = +1.9507
	
	if pi_flag
		h=1+1.8489*exp(-2.886*t).*sin(2.7532*t-0.540);
	else
		h=1+1.8489*exp(-2.886*t).*sin(2.7532*t-0.540+pi);
	end
	h=h-1.9507*exp(-3.6447*t);
	
	y=atdr([],p,t,'s');
	
	plot( t,g, t,h+0.01, t,y+0.02 )
	title('3-pole T-coil MFED System')
end

if X == 53
	% 3rd-order T-coil CD system
	t=t/2;
	RC=1;
	s1=-6/RC;
	w1=0;
	s2=-3/RC;
	p=[s1+j*w1 ; s1-j*w1 ; s2]
	if pi_flag
		w1=-w1 ;		% w = 0 , no change
	end
	
	% ar=atan(w1/s1)+atan(w1/(s1-s2));
	% ar=angle(s1+j*w1)+angle((s1-s2)+j*w1);
	% ad=ar*180/pi
	
	g=1;
%	g=g-(s2/(s1-s2))*(s1*t+(s2-2*s1)/(s1-s2)).*exp(s1*t);
	g=g+(s2^2/((s2-s1)^2))*(((s2-s1)*s1/s2)*t+2*s1/s2-1).*exp(s1*t);
	g=g-(s1^2/(s2-s1)^2)*exp(s2*t);
	
	h=1+3*(1+2*t).*exp(-6*t)-4*exp(-3*t);
	
	plot( t,g, t,h+0.01 )
	title('3-pole T-coil CD System')
end

if X == 61
	% 4th-order L+T MFA system
	t=t/2;
	RC=1;
	s1=-4.1213/RC;
	w1=1.7071/RC;
	s2=-1.7071/RC;
	w2=4.1213/RC;
	p=[s1+j*w1 ; s1-j*w1 ; s2+j*w2 ; s2-j*w2]
	if pi_flag
		w1=-w1 ;
		w2=-w2 ;
	end
	
	A=(s1-s2)^2 - (w1^2-w2^2);
	B=2*(s1-s2);
	C=(s1-s2)^2 + (w1^2-w2^2);
	K1=(s2^2+w2^2)/(A^2+w1^2*B^2);
	K2=(s1^2+w1^2)/(C^2+w2^2*B^2);
	M=sqrt( ( s1^2 + w1^2 ) * ( A^2 + w1^2 * B^2 ) );
	N=sqrt( ( s2^2 + w2^2 ) * ( C^2 + w2^2 * B^2 ) );
	
	ar1=atan( -w1 * ( A + s1*B ) / ( s1*A - w1^2*B ) )
	ad1=ar1*180/pi
	ar2=atan( -w2 * ( C - s2*B ) / ( s2*C + w2^2*B ) )
	ad2=ar2*180/pi
	
	g=1;
	if pi_flag
		g=g+(K1/w1)*M*exp(s1*t).*sin(w1*t+ar1);
		g=g+(K2/w2)*N*exp(s2*t).*sin(w2*t+ar2);
	else
		g=g+(K1/w1)*M*exp(s1*t).*sin(w1*t+ar1+pi);
		g=g+(K2/w2)*N*exp(s2*t).*sin(w2*t+ar2+pi);
	end
	
	h=1;
	
%	h=h+2.4142*exp(-4.1213*t).*sin(1.7071*t+0.9956+pi);
%	h=h+0.9968*exp(-1.7071*t).*sin(4.1213*t-0.9956+pi);		% 0.9956 ?????????
	if pi_flag
		h=h+2.4142*exp(-4.1213*t).*sin(1.7071*t+0.7854);
		h=h+0.9968*exp(-1.7071*t).*sin(4.1213*t-0.7854);
	else
		h=h+2.4142*exp(-4.1213*t).*sin(1.7071*t+0.7854+pi);
		h=h+0.9968*exp(-1.7071*t).*sin(4.1213*t-0.7854+pi);
	end
	
	y=atdr([],p,t,'s');
	
	plot( t,g, t,h+0.01, t,y+0.02 )
	title('4-pole L+T MFA System')
end

if X == 62
	% 4th-order L+T MFED-Thomson system
	t=t/2;
	RC=1;
	s1=-4.7317/RC;
	w1=1.4167/RC;
	s2=-3.4376/RC;
	w2=4.3419/RC;
	p=[s1+j*w1 ; s1-j*w1 ; s2+j*w2 ; s2-j*w2]
	if pi_flag
		w1=-w1 ;
		w2=-w2 ;
	end
	
	A=(s1-s2)^2 - (w1^2-w2^2);
	B=2*(s1-s2);
	C=(s1-s2)^2 + (w1^2-w2^2);
	K1=(s2^2+w2^2)/(A^2+w1^2*B^2);
	K2=(s1^2+w1^2)/(C^2+w2^2*B^2);
	M=sqrt( ( s1^2 + w1^2 ) * ( A^2 + w1^2 * B^2 ) );
	N=sqrt( ( s2^2 + w2^2 ) * ( C^2 + w2^2 * B^2 ) );
	
	ar1=atan( -w1 * ( A + s1*B ) / ( s1*A - w1^2*B ) )
	ad1=ar1*180/pi
	ar2=atan( -w2 * ( C - s2*B ) / ( s2*C + w2^2*B ) )
	ad2=ar2*180/pi
	
	g=1;
	g=g+(K1/w1)*M*exp(s1*t).*sin(w1*t+ar1+pi);
	g=g+(K2/w2)*N*exp(s2*t).*sin(w2*t+ar2);	% do not add pi here !!!!
	
	h=1+5.6632*exp(-4.7317*t).*sin(1.4167*t+0.4866+pi);
	h=h+1.6484*exp(-3.4376*t).*sin(4.3419*t+1.5389);	% do not add pi here !!!!
	
	y=atdr([],p,t,'s');
	
	plot( t,g, t,h+0.01, t,y+0.02 )
	title('4-pole L+T MFED System')
end

if X == 63
	% 4th-order L+T Group-A system
	t=t/2;
	RC=1;
	s1=-3.8332/RC;
	w1=1.7874/RC;
	s2=-2.1024/RC;
	w2=5.0013/RC;
	p=[s1+j*w1 ; s1-j*w1 ; s2+j*w2 ; s2-j*w2]
	if pi_flag
		w1=-w1 ;
		w2=-w2 ;
	end
	
	A=(s1-s2)^2 - (w1^2-w2^2);
	B=2*(s1-s2);
	C=(s1-s2)^2 + (w1^2-w2^2);
	K1=(s2^2+w2^2)/(A^2+w1^2*B^2);
	K2=(s1^2+w1^2)/(C^2+w2^2*B^2);
	M=sqrt( ( s1^2 + w1^2 ) * ( A^2 + w1^2 * B^2 ) );
	N=sqrt( ( s2^2 + w2^2 ) * ( C^2 + w2^2 * B^2 ) );
	
	ar1=atan( -w1 * ( A + s1*B ) / ( s1*A - w1^2*B ) )
	ad1=ar1*180/pi
	ar2=atan( -w2 * ( C - s2*B ) / ( s2*C + w2^2*B ) )
	ad2=ar2*180/pi
	
	g=1;
	g=g+(K1/w1)*M*exp(s1*t).*sin(w1*t+ar1+pi);
	g=g+(K2/w2)*N*exp(s2*t).*sin(w2*t+ar2+pi);
	
	h=1+2.7233*exp(-3.8332*t).*sin(1.7874*t+0.6807+pi);
	h=h+0.7587*exp(-2.1024*t).*sin(5.0013*t-1.2250+pi);	
	
	y=atdr([],p,t,'s');
	
	plot( t,g, t,h+0.01, t,y+0.02 )
	title('4-pole L+T Group-A System')
end

if X == 64
	% 4th-order L+T Group-C system
	t=t/2;
	RC=1;
	s1=-3.3252/RC;
	w1=0.5863/RC;
	s2=-1.7284/RC;
	w2=3.8475/RC;
	p=[s1+j*w1 ; s1-j*w1 ; s2+j*w2 ; s2-j*w2]
	if pi_flag
		w1=-w1 ;
		w2=-w2 ;
	end
	
	A=(s1-s2)^2 - (w1^2-w2^2);
	B=2*(s1-s2);
	C=(s1-s2)^2 + (w1^2-w2^2);
	K1=(s2^2+w2^2)/(A^2+w1^2*B^2);
	K2=(s1^2+w1^2)/(C^2+w2^2*B^2);
	M=sqrt( ( s1^2 + w1^2 ) * ( A^2 + w1^2 * B^2 ) );
	N=sqrt( ( s2^2 + w2^2 ) * ( C^2 + w2^2 * B^2 ) );
	
	ar1=atan( -w1 * ( A + s1*B ) / ( s1*A - w1^2*B ) )
	ad1=ar1*180/pi
	ar2=atan( -w2 * ( C - s2*B ) / ( s2*C + w2^2*B ) )
	ad2=ar2*180/pi
	
	g=1;
	g=g+(K1/w1)*M*exp(s1*t).*sin(w1*t+ar1+pi);
	g=g+(K2/w2)*N*exp(s2*t).*sin(w2*t+ar2+pi);
	
	h=1+5.9875*exp(-3.3252*t).*sin(0.5863*t+0.2843+pi);
	h=h+0.7310*exp(-1.7284*t).*sin(3.8475*t-1.1920+pi);
	
	y=atdr([],p,t,'s');
	
	plot( t,g, t,h+0.01, t,y+0.02 )
	title('4-pole L+T Group-C System')
end

if X == 65
	% 4th-order L+T Chebyshew 0.05 system
	t=t/2;
	RC=1;
	s1=-3.7912/RC;
	w1= 1.8565/RC;
	s2=-2.4861/RC;
	w2= 4.6775/RC;
	p=[s1+j*w1 ; s1-j*w1 ; s2+j*w2 ; s2-j*w2]
	if pi_flag
		w1=-w1 ;
		w2=-w2 ;
	end
	
	A=(s1-s2)^2 - (w1^2-w2^2);
	B=2*(s1-s2);
	C=(s1-s2)^2 + (w1^2-w2^2);
	K1=(s2^2+w2^2)/(A^2+w1^2*B^2);
	K2=(s1^2+w1^2)/(C^2+w2^2*B^2);
	M=sqrt( ( s1^2 + w1^2 ) * ( A^2 + w1^2 * B^2 ) );
	N=sqrt( ( s2^2 + w2^2 ) * ( C^2 + w2^2 * B^2 ) );
	
	ar1=atan( -w1 * ( A + s1*B ) / ( s1*A - w1^2*B ) )
	ad1=ar1*180/pi
	ar2=atan( -w2 * ( C - s2*B ) / ( s2*C + w2^2*B ) )
	ad2=ar2*180/pi
	
	g=1;
	g=g+(K1/w1)*M*exp(s1*t).*sin(w1*t+ar1+pi);
	g=g+(K2/w2)*N*exp(s2*t).*sin(w2*t+ar2+pi);
	(K1/w1)*M
	(K2/w2)*N
	h=1+3.0807*exp(-3.7912*t).*sin(1.8565*t+0.6915+pi); % +0.6952 ????
	h=h+0.9744*exp(-2.4861*t).*sin(4.6775*t-1.4289+pi); % -1.4270 ????
	
	y=atdr([],p,t,'s');
	
	plot( t,g, t,h+0.01, t,y+0.02 )
	title('4-pole L+T Chebyshew 0.05 System')
end

if X == 66
	% 4th-order L+T Gaussian to -12dB system
	t=t/2;
	RC=1;
	s1=-3.3835/RC;
	w1= 2.0467/RC;
	s2=-3.4150/RC;
	w2= 6.2556/RC;
	p=[s1+j*w1 ; s1-j*w1 ; s2+j*w2 ; s2-j*w2]
	if pi_flag
		w1=-w1 ;
		w2=-w2 ;
	end
	
	A=(s1-s2)^2 - (w1^2-w2^2);
	B=2*(s1-s2);
	C=(s1-s2)^2 + (w1^2-w2^2);
	K1=(s2^2+w2^2)/(A^2+w1^2*B^2);
	K2=(s1^2+w1^2)/(C^2+w2^2*B^2);
	M=sqrt( ( s1^2 + w1^2 ) * ( A^2 + w1^2 * B^2 ) );
	N=sqrt( ( s2^2 + w2^2 ) * ( C^2 + w2^2 * B^2 ) );
	
	ar1=atan( -w1 * ( A + s1*B ) / ( s1*A - w1^2*B ) )
	ad1=ar1*180/pi
	ar2=atan( -w2 * ( C - s2*B ) / ( s2*C + w2^2*B ) )
	ad2=ar2*180/pi
	
	g=1;
	g=g+(K1/w1)*M*exp(s1*t).*sin(w1*t+ar1+pi);
	g=g+(K2/w2)*N*exp(s2*t).*sin(w2*t+ar2); % no pi here
	% (K1/w1)*M
	% (K2/w2)*N
	h=1+2.8084*exp(-3.3835*t).*sin(2.0467*t+0.5403+pi);
	h=h+0.5098*exp(-3.4150*t).*sin(6.2556*t+1.0598); % no pi here
	
	y=atdr([],p,t,'s');
	
	plot( t,g, t,h+0.01, t,y+0.02 )
	title('4-pole L+T Gaussian to -12 dB System')
end

if X == 67
	% 4th-order L+T Double-2-pole Bessel system
	t=t/2;
	RC=1;
	s1=-4.5/RC;
	w1= 2.5981/RC;
	p=[s1+j*w1 ; s1-j*w1 ];
	q=p;
	if pi_flag
		w1=-w1 ;
	end
	
	ar1=-atan( w1/s1 )
	ad1=ar1*180/pi
	
	h=2*sin(w1*t+ar1);
	h=h+4*sin(w1*t)*cos(ar1);
	h=h-10.3923*t.*cos(w1*t+ar1);
	h=1-exp(s1*t).*h;
	
% Convolution of the step response by its own impulse response
	x=atdr([],p,t,'i');
	y=atdr([],p,t,'s');
	z=conv(y, x/sum(x));
	z=z(1:length(t));

	plot( t,z, t,x/max(x)+0.01, t,y, t,h+0.02 )
	title('4-pole L+T Double-2-pole Bessel System')
end

% 7x - 2-pole shunt
if X == 71
	% 2nd-order shunt-peaking MFA (2-pole, 1-zero)
	m=sqrt(2)-1;
	
	% pole components
	s1=-1/(2*m);
	w1= sqrt(4*m-1);
	% zero
	z =-1/m;

	% poles
	p=[s1+j*w1; s1-j*w1];
	p
	z
	if pi_flag
		w1=-w1 ;
	end
	
%	K=-1/z;
%	A=s1*(s1-z) + w1^2;
%	% B=z;
	
%	ar=atan( w1*z/K )
%	ad=ar*180/pi
	
%	g=1+(K/w1)*sqrt( A^2 + w1^2*z^2 )*exp(s1*t).*sin(w1*t+ar);
%	(K/w1)*sqrt( A^2 + w1^2*z^2 )
	
	ar=atan(w1*z/(w1^2+s1*(s1-z)))
	ad=ar*180/pi
	g=1-(sqrt(w1^2*z^2+(w1^2+s1*(s1-z))^2)/(w1*z))*exp(s1*t).*sin(w1*t+ar+pi);
-(sqrt(w1^2*z^2+(w1^2+s1*(s1-z))^2)/(w1*z))

	h=1+1.0804*exp(-1.2071*t).*sin(0.8105*t+1.1826+pi);
	
	y=atdr(z,p,t,'s');
	
	plot( t,g, t,h+0.01, t,y+0.02 )
	title( '2-pole, 1-zero shunt-peaking MFA system' )
end

if X == 72
	% 2nd-order shunt-peaking MFED (2-pole, 1-zero)
	m=0.3222;
	
	% pole components
	s1=-1/(2*m);
	w1= sqrt(4*m-1);
	% zero
	z =-1/m;

	% poles
	p=[s1+j*w1; s1-j*w1];
	p
	z
	if pi_flag
		w1=-w1 ;
	end
	
%	K=-1/z;
%	A=s1*(s1-z) + w1^2;
%	% B=z;
	
%	ar=atan( w1*z/K )
%	ad=ar*180/pi
	
%	g=1+(K/w1)*sqrt( A^2 + w1^2*z^2 )*exp(s1*t).*sin(w1*t+ar);
%	(K/w1)*sqrt( A^2 + w1^2*z^2 )
	
	ar=atan(w1*z/(w1^2+s1*(s1-z)))
	ad=ar*180/pi
	g=1-(sqrt(w1^2*z^2+(w1^2+s1*(s1-z))^2)/(w1*z))*exp(s1*t).*sin(w1*t+ar+pi);
-(sqrt(w1^2*z^2+(w1^2+s1*(s1-z))^2)/(w1*z))

	h=1+1.6170*exp(-1.5518*t).*sin(0.5374*t+0.6668+pi);
	
	y=atdr(z,p,t,'s');
	
	plot( t,g, t,h+0.01, t,y+0.02 )
	title( '2-pole, 1-zero shunt-peaking MFED system' )
end

if X == 73
	% 2nd-order shunt-peaking CD (2 real coincident poles, 1-zero)
	% pole components
	s1=-2;
	w1=0;
	% zero
	z =-4;
	% poles
	p=[s1;s1];
	if pi_flag
		w=-w ;		% w = 0 , no change
	end
	
	g=1+exp(s1*t).*(s1*(1-s1/z)*t-1);
	
	h=1+exp(-2*t).*(-t-1);
	
	plot( t,g, t,h+0.01 )
	title( '2 real poles, 1-zero shunt-peaking CR system' )
end

% 8x - 3-pole, 2-zero shunt
if X == 81
	% 3rd-order shunt-peaking MFA system
	t=t/2;
	% 3-poles, 2-zeros :
	s1=-0.850;
	w1= 1.577;
	s2=-2.125;
	
	sz=-1.412;
	wz= 2.197;
	
	p=[s1+j*w1; s1-j*w1; s2];	
	z=[sz+j*wz; sz-j*wz];
	if pi_flag
		w1=-w1 ;		% only w1, wz iz squared
	end
	
	A=s1*(s1-s2)-w1^2;
	B=2*s1-s2;
	C=(s1-sz)^2-(w1^2-wz^2);
	D=2*(s1-sz);
	
	K1=-s2/((sz^2 + wz^2)*((s1-s2)^2 + w1^2));
	
	M=A*C + w1^2*B*D;
	N=A*D - B*C ;
	
	ar=atan( w1*N/M )
	ad=ar*180/pi
	
	K2=-((s1^2+w1^2)/(sz^2+wz^2))*(((s2-sz)^2+wz^2)/((s2-s1)^2+w1^2));
	
	g=1+(K1/w1)*sqrt( M^2 + w1^2*N^2 )*exp(s1*t).*sin(w1*t+ar+pi);
	g=g+K2*exp(s2*t);
	(K1/w1)*sqrt( M^2 + w1^2*N^2 )
	K2

%	h=1+0.559*exp(-0.850*t).*sin(1.577*t+0.789+pi); % 0.789 ??????????
%	h=h-0.604*exp(-2.125*t);
	h=1+0.5573*exp(-0.850*t).*sin(1.577*t+0.7741+pi);
	h=h-0.6104*exp(-2.125*t);
	
	y=atdr(z,p,t,'s');
	
	plot( t,g, t,h+0.01, t,y+0.02 )
	title( '3-pole,2-zero shunt-peaking MFA system' )
end

if X == 82
	% 3rd-order shunt-peaking MFED system
	t=t/2;
	% 3-poles, 2-zeros :
	s1=-1.604;
	w1= 1.791;
	s2=-2.248;
	
	sz=-2.272;
	wz= 2.797;
	
	p=[s1+j*w1; s1-j*w1; s2]
	z=[sz+j*wz; sz-j*wz]
	if pi_flag
		w1=-w1 ;		% only w1, wz is squared
	end

	a=z;
	b=p;	
	[z,p]=bestap(3,'t');
	z=roots([1,5,15])
	p=cplxpair(p)
	s1=real(p(1))
	w1=abs(imag(p(1)))
	s2=p(3)
	sz=real(z(1))
	wz=imag(z(1))

	
	A=s1*(s1-s2)-w1^2;
	B=2*s1-s2;
	C=(s1-sz)^2-(w1^2-wz^2);
	D=2*(s1-sz);
	
	K1=-s2/((sz^2 + wz^2)*((s1-s2)^2 + w1^2));
	
	M=A*C + w1^2*B*D;
	N=A*D - B*C;
	
	ar=atan( w1*N/M )
	ad=ar*180/pi
	
	K2=-((s1^2+w1^2)/(sz^2+wz^2))*(((s2-sz)^2+wz^2)/((s2-s1)^2+w1^2));
	
	g=1+(K1/w1)*sqrt( M^2 + w1^2*N^2 )*exp(s1*t).*sin(w1*t+ar+pi);
	g=g+K2*exp(s2*t);
	
	(K1/w1)*sqrt( M^2 + w1^2*N^2 )
	K2
	
%	h=1+0.6836*exp(-1.604*t).*sin(1.791*t+0.0564+pi);
%	h=h-0.9615*exp(-2.248*t);
	h=1+0.8054*exp(-1.8389*t).*sin(1.7544*t-0.1772+pi);
	h=h-1.1420*exp(-2.3222*t);
	
	y=atdr(z,p,t,'s');
	disp(['deltay = ', num2str(round(10000*(max(y)-1))/100), ' %'])
	
	v=atdr(a,b,t,'s');
	disp(['deltav = ', num2str(round(10000*(max(v)-1))/100), ' %'])
	
	plot( t,g, t,h+0.01, t,y+0.02, t,v+0.03 )
	title( '3-pole,2-zero shunt-peaking MFED system' )
end

if X == 83
	% 3rd-order shunt-peaking SPEC system
	t=t/2;
	% 3-poles, 2-zeros :
	s1=-1.035;
	w1= 1.355;
	s2=-3.475;
	
	sz=-2.237;
	wz= 2.222;
	
	p=[s1+j*w1; s1-j*w1; s2];	
	z=[sz+j*wz; sz-j*wz];
	if pi_flag
		w1=-w1 ;		% only w1, wz is squared
	end
	
	A=s1*(s1-s2)-w1^2;
	B=2*s1-s2;
	C=(s1-sz)^2-(w1^2-wz^2);
	D=2*(s1-sz);
	
	K1=-s2/((sz^2 + wz^2)*((s1-s2)^2 + w1^2))
	
	M=A*C + w1^2*B*D
	N=A*D - B*C
	
	ar=atan( w1*N/M )
	ad=ar*180/pi
	
	K2=-((s1^2+w1^2)/(sz^2+wz^2))*(((s2-sz)^2+wz^2)/((s2-s1)^2+w1^2));
	
	g=1+(K1/w1)*sqrt( M^2 + w1^2*N^2 )*exp(s1*t).*sin(w1*t+ar+pi);
	g=g+K2*exp(s2*t);
	
	(K1/w1)*sqrt( M^2 + w1^2*N^2 )
	K2
	
	h=1+0.8814*exp(-1.035*t).*sin(1.355*t+1.0333+pi);
	h=h-0.2429*exp(-3.475*t);
	
	y=atdr(z,p,t,'s');
	
	plot( t,g, t,h+0.01, t,y+0.02 )
	title( '3-pole,2-zero shunt-peaking SPEC system' )
end

% 9x - shunt-series (4-pole, 1-zero)
if X == 91
	% MFA (Shea) shunt-series (4-pole, 1-zero)
	t=t/2;
	% pole components
	s1 =-2.4042;
	w1 = 1.0053;
	s2 =-0.9971;
	w2 = 2.4161;
	
	% zero
	z=-6.8027
	% poles
	p=[s1+j*w1; s1-j*w1; s2+j*w2; s2-j*w2]
	if pi_flag
		w1=-w1 ;
		w2=-w2 ;
	end
	
	[a,b]=buttap(4);
	kx=(real(prod(-p)))^(1/length(p));
	kx=kx/(real(prod(-b)))^(1/length(b));
%	kx=kx/(prod(-z))^(1/length(z));
	a=z*kx
	b=b*kx
	poly(b)

plot( real(p), imag(p), 'r*', real(b), imag(b), 'b+', [-3,3], [3,-3], '.k' )
axis('square')
pause
	
	A=(s1-s2)^2 - (w1^2-w2^2);
	B=2*(s1-s2);
	C=(s1-s2)^2 + (w1^2-w2^2);
	K1=(s2^2 + w2^2)/(A^2 + w1^2*B^2);
	K2=(s1^2 + w1^2)/(C^2 + w2^2*B^2);
	
	M=(s1-z)*(s1*A - w1^2*B) + w1^2*(A + s1*B);
	N=(s1*A - w1^2*B) - (s1-z)*(A + s1*B);
	P=(s2-z)*(s2*C + w2^2*B) + w2^2*(C - s2*B);
	Q=(s2*C + w2^2*B) - (s2-z)*(C - s2*B);
	
	ar1=atan( w1*N/M );
	ar2=atan( w2*Q/P );
	ad1=ar1*180/pi
	ad2=ar2*180/pi
	
	g=1;
	g=g-(K1/(w1*z))*sqrt( M^2 + w1^2*N^2 )*exp(s1*t).*sin(w1*t+ar1+pi);
	g=g-(K2/(w2*z))*sqrt( P^2 + w2^2*Q^2 )*exp(s2*t).*sin(w2*t+ar2+pi);
	
	y=atdr(z,p,t,'s');
	f=atdr(a,b,t,'s');
	u=atdr(z,b,t,'s');
	v=atdr([],b,t,'s');
	
	plot( t,g, t,y+0.01, t,f+0.02, t,u+0.03, t,v+0.04 );
	title( '4-pole, 1-zero shunt-series MFA (Shea)')
end

if X == 92
	% MFED (Shea) shunt-series (4-pole, 1-zero)
	t=t/2;
	% pole components
	s1 =-2.1250;
	w1 = 1.0971;
	s2 =-1.6231;
	w2 = 3.1625;
	
	% zero
	z=-7.4963
	% poles
	p=[s1+j*w1; s1-j*w1; s2+j*w2; s2-j*w2]
	if pi_flag
		w1=-w1 ;
		w2=-w2 ;
	end
	
	[a,b]=bestap(4,'t')
	
	w=logspace(-1,1,1001);
	F=freqw(z,p,w);
	G=freqw(a,b,w);
	xf=max(find(abs(F)>=0.7071))
	xg=max(find(abs(G)>=0.7071))
	w(xf), abs(F(xf)), w(xg), abs(G(xg))
%	loglog( w, abs(F), w,abs(G) )
%	axis([0.1,10,0.7,1])
%	pause

%	kx=(real(prod(-p)))^(1/length(p));
%	kx=kx/(real(prod(-b)))^(1/length(b))
	kx=w(xf)/w(xg);

	a=z*kx
	d=b*kx
	
	cd=poly(d)
		
figure(1)
plot( real(p), imag(p), 'r*',...
      real(b), imag(b), 'b+',...
      real(d), imag(d), 'gx',...
      [-4,+4], [ 0, 0], '-k',...
      [ 0, 0], [-4,+4], '-k' )
axis('square')
text( 0.1, 2.0, 'poles :' )
text( 0.1, 1.5, 'Shea (red *)' )
text( 0.1, 1.0, 'Bessel (blue +)' )
text( 0.1, 0.5, ['Bessel x ' num2str(round(kx*100)/100), ' (green x)'] )
	
	A=(s1-s2)^2 - (w1^2-w2^2);
	B=2*(s1-s2);
	C=(s1-s2)^2 + (w1^2-w2^2);
	K1=(s2^2 + w2^2)/(A^2 + w1^2*B^2);
	K2=(s1^2 + w1^2)/(C^2 + w2^2*B^2);
	
	M=(s1-z)*(s1*A - w1^2*B) + w1^2*(A + s1*B);
	N=(s1*A - w1^2*B) - (s1-z)*(A + s1*B);
	P=(s2-z)*(s2*C + w2^2*B) + w2^2*(C - s2*B);
	Q=(s2*C + w2^2*B) - (s2-z)*(C - s2*B);
	
	ar1=atan( w1*N/M )
	ar2=atan( w2*Q/P )
	ad1=ar1*180/pi
	ad2=ar2*180/pi
	
	g=1;
	g=g-(K1/(w1*z))*sqrt( M^2 + w1^2*N^2 )*exp(s1*t).*sin(w1*t+ar1+pi);
	g=g-(K2/(w2*z))*sqrt( P^2 + w2^2*Q^2 )*exp(s2*t).*sin(w2*t+ar2+pi);
delta=max(g)
	
	h=1+2.210*exp(-2.125*t).*sin(1.0971*t+0.7992+pi);
	h=h+0.627*exp(-1.623*t).*sin(3.1620*t-1.1954+pi);
	
	% max.bandwidth for n=0.5 ;
	% but Ci > C !!!!!!!! ?????? not true !
	n=0.707
%	m1=1/cx(2)
%	m2=(cx(2)/cx(5))/(n*(1-n))
%	m3=((cx(3)/cx(5))-m1)/n
%	zx=-1/m1
	m1=1/sum(-d)
	m2=(1/(d(1)*d(2))) + (1/(d(3)*d(4))) ;
	m2=m2 + (d(1)+d(2))*(d(3)+d(4))/prod(d) ;
	m2=real(m2 - m1)
	zx=-1/m1
	
	y=atdr(z,p,t,'s');
	f=atdr([],b,t,'s');
	u=atdr(a,d,t,'s');
%	v=atdr(zx,b,t,'s');
	
	figure(2)
	plot( t,g, t,h+0.01, t,y+0.02 );
	title( '4-pole, 1-zero shunt-series MFED (Shea)')
	figure(3)
%	plot( t,y, '-r', t,f, '-g', t,u, '-b', t,v, '-c' );
	plot( t,y, '-r', t,f+0.01, '-g', t,u+0.02, '-b' );
	title( '4-pole, 1-zero shunt-series MFED (RXon)')
	text( 1.5, 0.4, '  red : Shea' )
	text( 1.5, 0.3, 'green : Bessel, no zero' )
	text( 1.5, 0.2, [' blue : Bessel * ', num2str(round(kx*100)/100), ' + z=', num2str(round(a*100)/100)] )
%	text( 1.5, 0.1, [' cian : Bessel, z=-10'] )
end

if X == 93
	% MFA (Braude) shunt-series (4-pole, 1-zero)
	t=t/2;
	% pole components
	s1 =-2.4397;
	w1 = 0.9730;
	s2 =-1.0568;
	w2 = 2.4707;
	
	% zero
	z=-6.9930
	% poles
	p=[s1+j*w1; s1-j*w1; s2+j*w2; s2-j*w2]
	if pi_flag
		w1=-w1 ;
		w2=-w2 ;
	end
	
	[a,b]=buttap(4);
	kx=(real(prod(-p)))^(1/length(p));
	kx=kx/(real(prod(-b)))^(1/length(b));
%	kx=kx/(prod(-z))^(1/length(z));
	a=z*kx
	b=b*kx
	poly(b)
	
plot( real(p), imag(p), 'r*', real(b), imag(b), 'b+', [-3,3], [3,-3], '.k' )
axis('square')
pause
	
	A=(s1-s2)^2 - (w1^2-w2^2);
	B=2*(s1-s2);
	C=(s1-s2)^2 + (w1^2-w2^2);
	K1=(s2^2 + w2^2)/(A^2 + w1^2*B^2);
	K2=(s1^2 + w1^2)/(C^2 + w2^2*B^2);
	
	M=(s1-z)*(s1*A - w1^2*B) + w1^2*(A + s1*B);
	N=(s1*A - w1^2*B) - (s1-z)*(A + s1*B);
	P=(s2-z)*(s2*C + w2^2*B) + w2^2*(C - s2*B);
	Q=(s2*C + w2^2*B) - (s2-z)*(C - s2*B);
	
	ar1=atan( w1*N/M );
	ar2=atan( w2*Q/P );
	ad1=ar1*180/pi
	ad2=ar2*180/pi
	
	g=1;
	g=g-(K1/(w1*z))*sqrt( M^2 + w1^2*N^2 )*exp(s1*t).*sin(w1*t+ar1+pi);
	g=g-(K2/(w2*z))*sqrt( P^2 + w2^2*Q^2 )*exp(s2*t).*sin(w2*t+ar2+pi);
	
	y=atdr(z,p,t,'s');
	f=atdr(a,b,t,'s');
	u=atdr(z,b,t,'s');
	v=atdr([],b,t,'s');
	
	plot( t,g, t,y+0.01, t,f+0.02, t,u+0.03, t,v+0.04 );
	title( '4-pole, 1-zero shunt-series MFA (Braude)')
end

if X == 94
	% MFED (Braude) shunt-series (4-pole, 1-zero)
	t=t/2;
	% pole components
	s1 =-2.6032;
	w1 = 0.9618;
	s2 =-1.4951;
	w2 = 2.6446;
	
	% zero
	z=-8.1967
	% poles
	p=[s1+j*w1; s1-j*w1; s2+j*w2; s2-j*w2]
	if pi_flag
		w1=-w1 ;
		w2=-w2 ;
	end
	
	[a,b]=bestap(4,'t');
	kx=(real(prod(-p)))^(1/length(p));
	kx=kx/(real(prod(-b)))^(1/length(b));
%	kx=kx/(prod(-z))^(1/length(z));
	a=z*kx
	d=b*kx
	poly(b)
	
figure(1)
plot( real(p), imag(p), 'r*',...
      real(b), imag(b), 'b+',...
      real(d), imag(d), 'gx',...
      [-4, 4], [ 0, 0], '-k',...
      [ 0, 0], [-4, 4], '-k' )
axis('square')
text( -1, 1, 'poles by Braude (red *)' )
text( -1,-1, 'Bessel poles, corrected (blue +)' )
	
	A=(s1-s2)^2 - (w1^2-w2^2);
	B=2*(s1-s2);
	C=(s1-s2)^2 + (w1^2-w2^2);
	K1=(s2^2 + w2^2)/(A^2 + w1^2*B^2);
	K2=(s1^2 + w1^2)/(C^2 + w2^2*B^2);
	
	M=(s1-z)*(s1*A - w1^2*B) + w1^2*(A + s1*B);
	N=(s1*A - w1^2*B) - (s1-z)*(A + s1*B);
	P=(s2-z)*(s2*C + w2^2*B) + w2^2*(C - s2*B);
	Q=(s2*C + w2^2*B) - (s2-z)*(C - s2*B);
	
	ar1=atan( w1*N/M );
	ar2=atan( w2*Q/P );
	ad1=ar1*180/pi
	ad2=ar2*180/pi
	
	g=1;
	g=g-(K1/(w1*z))*sqrt( M^2 + w1^2*N^2 )*exp(s1*t).*sin(w1*t+ar1+pi);
	g=g-(K2/(w2*z))*sqrt( P^2 + w2^2*Q^2 )*exp(s2*t).*sin(w2*t+ar2+pi);
delta=max(g)
	
	cx=poly(b);
	% n =1-1/((cx(2)/cx(3))-cx(5))
	n=0.5			% max.bandwidth for n=0.5 ;
					% but Ci > C !!!!!!!!
	m1=1/cx(2)
	m2=(cx(2)/cx(5))/(n*(1-n))
	m3=((cx(3)/cx(5))-m1)/n
	zx=-1/m1
	
	y=atdr(z,p,t,'s');
	f=atdr(a,b,t,'s');
	u=atdr(zx,b,t,'s');
	v=atdr([],b,t,'s');
	
	figure(2)
	plot( t,g, t,y+0.01 );
	title( '4-pole, 1-zero shunt-series MFED (Braude)')
	figure(3)
	plot( t,y, '-r', t,f+0.01, '-g',  t,u+0.02, '-b', t,v+0.03, '-c' );
	title( '4-pole, 1-zero shunt-series MFED (RXon)')
	text( 1.5, 0.4, 'red   : Braude' )
	text( 1.5, 0.3, 'green : Bessel + zero corrected' )
	text( 1.5, 0.2, 'blue  : Bessel + zero from n=0.5 (red)' )
	text( 1.5, 0.1, 'cian  : Bessel (no zero)' )
end

if X == 95
	% SPEC (Braude) shunt-series (4-poles, 2 real, 1-zero)
	t=t/2;
	% pole components
	s1 = -1.9693;
	w1 =  2.0492;
	s2 = -3.0096;
	s3 = -5.5518;
%	D=[1;12.5;50.507;134.9637;134.9637];
%	roots(D)			% ???????????????????????
%	s1 = -1.3902;
%	w1 =  2.8474;
%	s2 = -1.6699;
%	s3 = -8.0497;
	
	% zero
	z = -12.5000;
	% poles
	p=[s1+j*w1; s1-j*w1; s2; s3];
	if pi_flag
		w1=-w1 ;
		w2=-w2 ;
	end
	
	A=(s1-s2)*(s1-s3) - w1^2;
	B=2*s1 - s2 - s3;
	C=s1^2 + w1^2 - s1*z;
	K1=s2*s3/(A^2 + w1^2*B^2);
	K2=(s1^2 + w1^2)/(((s2-s1)^2 + w1^2)*(s2-s3));
	K3=(s1^2 + w1^2)/(((s3-s1)^2 + w1^2)*(s3-s2));
	
	M=C*A + z*w1^2*B;
	N=z*A - C*B;
	
	ar=atan( w1*N/M );
	ad=ar*180/pi
	
	g=1;
	g=g-(K1/(z*w1))* sqrt( M^2 + w1^2*N^2 )*exp(s1*t).*sin(w1*t+ar+pi);
	g=g-(K2/z)*s3*(s2-z)*exp(s2*t);
	g=g-(K3/z)*s2*(s3-z)*exp(s3*t);

	y=atdr(z,p,t,'s');
	
	plot( t,g, t,y+0.01 );
	title( '4-pole(2 real) + 1-zero shunt-series SPEC (Braude)')
end

if X == 96
	% MFA (RXon) shunt-series (4-pole, 1-zero)
	t=t/2;
	% pole components
	s1 =-2.4142;
	w1 = 1.0000;
	s2 =-1.0000;
	w2 = 2.4142;
	
	% zero
	z=-6.8284
	% poles
	p=[s1+j*w1; s1-j*w1; s2+j*w2; s2-j*w2]
	if pi_flag
		w1=-w1 ;
		w2=-w2 ;
	end
	
	k1=2.6131
	[a,b]=buttap(4);
	b=b*k1 

	A=(s1-s2)^2 - (w1^2-w2^2);
	B=2*(s1-s2);
	C=(s1-s2)^2 + (w1^2-w2^2);
	K1=(s2^2 + w2^2)/(A^2 + w1^2*B^2);
	K2=(s1^2 + w1^2)/(C^2 + w2^2*B^2);
	
	M=(s1-z)*(s1*A - w1^2*B) + w1^2*(A + s1*B);
	N=(s1*A - w1^2*B) - (s1-z)*(A + s1*B);
	P=(s2-z)*(s2*C + w2^2*B) + w2^2*(C - s2*B);
	Q=(s2*C + w2^2*B) - (s2-z)*(C - s2*B);
	
	ar1=atan( w1*N/M )
	ar2=atan( w2*Q/P )
	ad1=ar1*180/pi
	ad2=ar2*180/pi
	
	g=1;
	g=g-(K1/(w1*z))*sqrt( M^2 + w1^2*N^2 )*exp(s1*t).*sin(w1*t+ar1+pi);
	g=g-(K2/(w2*z))*sqrt( P^2 + w2^2*Q^2 )*exp(s2*t).*sin(w2*t+ar2+pi);
delta=max(g)
	
(K1/(w1*z))*sqrt( M^2 + w1^2*N^2 )
(K2/(w2*z))*sqrt( P^2 + w2^2*Q^2 )
	
	h=1+1.6002*exp(-2.4142*t).*sin(1.000*t+1.0082+pi);
	h=h+0.9239*exp(-1.0000*t).*sin(2.4142*t-0.3927+pi);
	
	n=0.5858
	m1=0.1464
	m2=0.6036
	zx=-1/m1
	
	y=atdr(z,p,t,'s');
	
	figure(2)
	plot( t,g, t,h+0.01, t,y+0.02 );
	title( '4-pole, 1-zero shunt-series MFA (RXon)')
end

if X == 97
	% MFED (RXon) shunt-series (4-pole, 1-zero)
	t=t/2;
	% pole components
	s1 =-2.8962;
	w1 = 0.8672;
	s2 =-2.1038;
	w2 = 2.6574;
	
	% zero
	z=-10.0000
	% poles
	p=[s1+j*w1; s1-j*w1; s2+j*w2; s2-j*w2]
	if pi_flag
		w1=-w1 ;
		w2=-w2 ;
	end
	
	[a,b]=bestap(4,'t')

	A=(s1-s2)^2 - (w1^2-w2^2);
	B=2*(s1-s2);
	C=(s1-s2)^2 + (w1^2-w2^2);
	K1=(s2^2 + w2^2)/(A^2 + w1^2*B^2);
	K2=(s1^2 + w1^2)/(C^2 + w2^2*B^2);
	
	M=(s1-z)*(s1*A - w1^2*B) + w1^2*(A + s1*B);
	N=(s1*A - w1^2*B) - (s1-z)*(A + s1*B);
	P=(s2-z)*(s2*C + w2^2*B) + w2^2*(C - s2*B);
	Q=(s2*C + w2^2*B) - (s2-z)*(C - s2*B);
	
	ar1=atan( w1*N/M )
	ar2=atan( w2*Q/P )
	ad1=ar1*180/pi
	ad2=ar2*180/pi
	
	g=1;
	g=g-(K1/(w1*z))*sqrt( M^2 + w1^2*N^2 )*exp(s1*t).*sin(w1*t+ar1+pi);
	g=g-(K2/(w2*z))*sqrt( P^2 + w2^2*Q^2 )*exp(s2*t).*sin(w2*t+ar2+pi);
delta=max(g)
	
(K1/(w1*z))*sqrt( M^2 + w1^2*N^2 )
(K2/(w2*z))*sqrt( P^2 + w2^2*Q^2 )
	
	h=1+4.0525*exp(-2.8962*t).*sin(0.8672*t+0.6080+pi);
	h=h+1.3733*exp(-2.1038*t).*sin(2.6574*t-1.2780+pi);
	
	n=0.7101
	m1=0.1000
	m2=0.4627
	zx=-1/m1
	
	y=atdr(z,p,t,'s');
	
	figure(2)
	plot( t,g, t,h+0.01, t,y+0.02 );
	title( '4-pole, 1-zero shunt-series MFED (RXon)')

end


