% Step-response of 5th-order system and of
% three saparate stages with same poles.

% RXon, 20020311

[z,p]=bestap(5,'t');
t=0:0.01:3;

[q,ix]=sort(abs(imag(p)));
p=p(ix);

a=p(1);
b=p(2:3);
c=p(4:5);

ia=atdr(z,a,t,'n');
sa=atdr(z,a,t,'s');
ib=atdr(z,b,t,'n');
sb=atdr(z,b,t,'s');
ic=atdr(z,c,t,'n');
sc=atdr(z,c,t,'s');

figure(1);
plot(t,sa,t,sb,t,sc);
xlabel('t/T')


y12=conv(sc,ib);
y12=y12(1:length(t));
y13=conv(y12,ia);
y13=y13(1:length(t));

figure(2);
plot(t,sc,t,y12,t,y13);
xlabel('t/T')

y22=conv(sa,ib);
y22=y22(1:length(t));
y23=conv(y22,ic);
y23=y23(1:length(t));
figure(3)
plot(t,sa,t,y22,t,y23);
xlabel('t/T')


