function clc401
%CLC401	Current-FeedBack Amplifier symmulation.
%	Trans-Impedance Equation :
%					Vo = Ie * Zt
%	Feedback Error Current :
%					Ie = Vi/Rp + (Vi-Vo)/Rs =
%					   = Vi*(Rs+Rp)/(Rs*Rp) - Vo/Rs
%	Trans-Impedance Model :
%					Zt = 1/(1/Rt + j*w*Ct)
%	Closed-Loop Gain :
%				     Vo/Vi = (1+Rs/Rp)/(1+Rs/Zt) =
%			= (1+Rs/Rp)/((1+Rs/Rt)*(1+j*w*Ct*Rs*Rt/(Rs+Rt)))
%	Open-Loop Gain :
%				     Vo/Vi = Rt/(Rp*(1+j*w*Ct*Rt))
%	Non-Ideal Closed-Loop Gain :
%	    Vo/Vi = 1 ./((Rr+Rs*Rp/(Rs+Rp))*(1/Rt+w*Ct+1/(Rs+Rp*Rr/(Rp+Rr))))
%	Ie in time domain :
%	   Ie = Vi*(1/Rs+1/Rp)*(1-(1/(1+Rs/Rt))*(1-exp(-t*(Rs+Rt)/(Ct*Rs*Rt))))


%	E.M., 920702

Rs=1500;		% []
Rp=300;			% []
R=[150;300;750;1500];	% []
Rt=150000;		% []
Ct=30*10^(-12);		% [F]
Rr=15;			% []

Ro=150;
Co=10*10^(-12);

f=logspace(6,10,401);
w=j*2*pi*f;
% Zt=1 ./(Ct*w+1/Rt);

for kx=1:max(size(R))
	Rp=R(kx);
	G=1/(1+Rr/Rp+Rr/Rs);
	Hc=(1-G) ./(Rr*(Ro*Co*w).*(w*Ct+1/Rt) - G*Rr/Rs);
	
	loglog(f,abs(Hc))
	hold on
end
hold off
