function frx(Ct)
%FRX	CFB Amp Frequecy response. eXperimental.
%
%	Use :	frx;
%	or  :   frx(Ct);

Rt=30000;	% []
Rs=3000;	% []
Rp=300;		% []
Rr=15;		% []

f0=20000;	% [Hz]
A0=-.1;		% [dB]
M0=10^(A0/20);

if nargin == 0
	Ct=600*10^(-12);    %[F]
end

%CFB	Current-FeedBack Amplifier equations.
%	Trans-Impedance Equation :
%					Vo = Ie * Zt
%	Feedback Error Current :
%					Ie = Vi/Rp + (Vi-Vo)/Rs =
%					   = Vi*(Rs+Rp)/(Rs*Rp) - Vo/Rs
%	Trans-Impedance Model :
%					Zt = 1/(1/Rt + j*w*Ct)
%	Closed-Loop Gain :
%				     Vo/Vi = (1+Rs/Rp)/(1+Rs/Zt) =
%			= (1+Rs/Rp)/((1+Rs/Rt)*(1+j*w*Ct*Rs*Rt/(Rs+Rt)))
%	Open-Loop Gain :
%				     Vo/Vi = Rt/(Rp*(1+j*w*Ct*Rt))
%	Non-Ideal Closed-Loop Gain :
%	    Vo/Vi = 1 ./((Rr+Rs*Rp/(Rs+Rp))*(1/Rt+w*Ct+1/(Rs+Rp*Rr/(Rp+Rr))))
%	Ie in time domain :
%	   Ie = Vi*(1/Rs+1/Rp)*(1-(1/(1+Rs/Rt))*(1-exp(-t*(Rs+Rt)/(Ct*Rs*Rt))))


%	E.M., 920702


f=logspace(3,4,101);
w=j*2*pi*f;

% Hc=(1+Rs/Rp) ./((1+Rs/Rt)*(1+w*Ct*Rs*Rt/(Rs+Rt)));
% Ho=Rt ./(Rp*(1+w*Ct*Rt));
% Hn=1 ./((Rr+Rs*Rp/(Rs+Rp))*(1/Rt+w*Ct+1/(Rs+Rp*Rr/(Rp+Rr))));

Hx=1 ./(1+w*Rs*Ct);

% loglog(f,abs(Ho),f,abs(Hc),f,abs(Hn),f,abs(Hc.*Hx))
% pause

Hc=(1+Rs/Rp) ./((1+Rs/Rt)*(1+w*Ct*Rs*Rt/(Rs+Rt)));
Hc0=(1+Rs/Rp) ./(1+Rs/Rt);	% gain at d.c.;
Hc=Hc/Hc0;			% norm gain at d.c. to 1 ;
Hc=Hc.*Hx;			% input Rs*Ct time const ;

semilogx(f,20*log10(abs(Hc)))
title('Magnitude in dB')
pause
semilogx(f,180*angle(Hc)/pi)
title('Phase angle in degrees')
