function a703
% A703		Amplifier, 7-pole, 2-stage ; maximize bandwidth.
%			Investigation of an additional real pole at the input.
%			s0 = [10, 2, 1.1] * sa ;

% RXon, 20030316

f = logspace( 6, 9, 601 ) ;
t = 1e-9 * ( 0 : 0.05 : 20 ) ;

A = 10 ;
Cb = 11e-12 ;
Ca =  4e-12 ;
gm0 = 0.01 ;
% Rb = sqrt( A ) / gm0 ;
Rb = 360 ;

[z,p] = bestap(7,'t');
[K,ix] = sort( abs(p) );
p = p(ix) ;

cstr = [ 'k' ; 'b' ; 'g' ; 'r' ] ;
x = [ 10, 2, 1.1 ] ;
p = [ p; p(1) * x(1) ] ;

for k = 1 : 4
	p(8) = p(1) * x(k) ;
	disp(p) ;
	
	Da = p(1) ;
	Db = real( p(3) ) / ( cos( angle( p(3) ) ) )^2 ;
	Dc = real( p(5) ) / ( cos( angle( p(5) ) ) )^2 ;
	Dd = real( p(7) ) / ( cos( angle( p(7) ) ) )^2 ;
	
	Cc = Cb * ( Db / Dc ) / 2 ;
	Cd = 4 * Ca * ( Da / Dd ) ;
	
	Ra = Rb * ( Db / Da ) * ( Cb / Ca ) / 4 ;
	
	Lb = Rb^2 * Cb ;
	Ld = Ra^2 * Cd ;
	Lc = Rb^2 * Cc / ( 4 * ( cos( angle( p(3) ) ) )^2 ) ;
	
	kb = ( 3 - ( tan( angle( p(3) ) ) )^2 ) / ( 5 + ( tan( angle( p(3) ) ) )^2 ) ;
	kd = ( 3 - ( tan( angle( p(7) ) ) )^2 ) / ( 5 + ( tan( angle( p(7) ) ) )^2 ) ;
	
	Cbb = Cb * ( 1 + ( tan( angle( p(3) ) ) )^2 ) / 16 ;
	Cbd = Cd * ( 1 + ( tan( angle( p(7) ) ) )^2 ) / 16 ;
	
	A = gm0^2 * Ra * Rb ;
	
	disp( [ num2str(k), ')' ] ) ;
	disp( '    A         Ra[k]     Rb[k]     Cc[pF]    Cd[pF]    Cbb[pF]   Cbd[pF]   ' ) ;
	disp( '--------------------------------------------------------------------------' ) ;
	disp( [ A, Ra, Rb, 1e+12*[ Cc, Cd, Cbb, Cbd ] ] ) ;
	disp( ' ' ) ;
	disp( '    Lb[uH]    Lc[uH]    Ld[uH]    kb        kd     ' ) ;
	disp( '---------------------------------------------------' ) ;
	disp( [ 1e+6*[ Lb, Lc, Ld ], kb, kd ] ) ;
	disp( ' ' ) ;  
	
	pa = -1 / ( Ra * Ca ) ;
	
	re = cos( angle( p(3) ) ) ;
	im = sin( angle( p(3) ) ) ;
	pb = [ -re + j*im ; -re - j*im ] ;
	pb = pb * 4 * cos( angle( p(3) ) ) / ( Rb * Cb ) ;
	
	re = cos( angle( p(5) ) ) ;
	im = sin( angle( p(5) ) ) ;
	pc = [ -re + j*im ; -re - j*im ] ;
	pc = pc * 2 * cos( angle( p(5) ) ) / ( Rb * Cc ) ;
	
	re = cos( angle( p(7) ) ) ;
	im = sin( angle( p(7) ) ) ;
	pd = [ -re + j*im ; -re - j*im ] ;
	pd = pd * 4 * cos( angle( p(7) ) ) / ( Ra * Cd ) ;
	
	q = [ pa ; pb ; pc ; pd ] ;
	q = [ q; q(1) * x(k) ];
	
	figure(1)
	plot( real(q)*(1+k/33), imag(q)*(1+k/33), ['*', cstr(k)] )
	axis equal ;
	hold on ;
	
	F = freqw( z, q, 2*pi*f ) ;
	figure(2)
	loglog( f, A * ( abs( F ) ), ['-', cstr(k)] )
	axis( [ 1e+6, 1e+9, 1, 20.0] ) ;
	hold on ;
	
	y = atdr( z, q, t ) ;
	figure(3)
	plot( t, A * y, ['-', cstr(k)] )
	hold on ;
end
