function [E,A]=efitpar(p,d)
% EFITPAR ... parametric-equation ellipse fit to a system of poles.
%
%	Call :  [ E, A ] = efitpar( p, d ) ;
%	where:		p ... system poles in the complex plane
%				d ... ploting option, plots the poles and the elllipse
%						if non-zero
%				E ... a 500-by-2 matrix of [X(:), Y(:)] coordinates of
%						the ellipse
%				A ... a 1-by-4 matrix of ellipse parameters :
%						excentricity, major axis, minor axis,
%						intersection with the real axis

% RXon, 880311
% Last update : 000208
% Reworked for Matlab-V : 000811
% [A] should return either the center of symmetry or both focus coordinates !!!!!
% This has not been done yet !

test = 0 ;
tx = 1 ;

np = length( p ) ;
p = sort( p ) ;

p1 = abs( p( 1 ) ) ;
p2 = abs( p( np ) ) ;

x1 = real( p( 1 ) ) ;
x2 = real( p ( np ) ) ;

y1 = imag( p( 1 ) ) ;
y2 = imag( p ( np ) ) ;

s=sum(abs(imag(p)))-sum(abs(real(p)));
if ( ( abs(s) < 1e-6 ) | ( np == 1 ) )
	%Butterworth system
	exc = 0 ;
	c = 0 ;
	a = p1 ;
	b = a ;
	x0 = a ;
	y0 = a ;
elseif s > 0
	% Chebyshew system
	exc = sqrt( 1 + ( x1^2 - x2^2 ) / ( y1^2 - y2^2 ) ) ;
	a = sqrt( y2^2 - x2^2 / ( exc^2 - 1 ) ) ;
	c = abs( a * exc ) ;
	b = a * sqrt( 1 - exc^2 ) ;
	y0 = a ;
	x0 = -abs( b ) ;
else
	% Bessel system
	exc = ( p2 - p1 ) / ( x1 - x2 ) ;
	if np == 2
		exc = -0.45389 / 1.0068 ;
	end
	a = ( p2 + exc * x2 ) / ( 1 - exc^2 ) ;
	c = abs( a * exc ) ;
	b = a * sqrt( 1 - exc^2 ) ;
	y0 = b^2 / a ; 
	x0 = c - a ;
end

if test
	% A = [ exc, a, b, x0 ] ;
	disp( [ 'excentricity : exc = ', num2str(exc) ] )
	disp( [ 'major axis   :   a = ', num2str(a) ] )
	disp( [ 'minor axis   :   b = ', num2str(b) ] )
	disp( [ 'center       :   c = ', num2str(c) ] )
	disp( [ 'shift        :  x0 = ', num2str(x0) ] )
end

nx = 500 ;
% xx = x0 * ( 0 : 1/nx : 1 ) ;
xx = x0 + ( 2*c - 2*x0 ) * ( 0 : 1/nx : 1 ) ;

if ( ( abs(s) < 1e-6 ) | ( np == 1 ) )
	%Butterworth system
	yy = sqrt( a^2 - xx.^2 ) ;
elseif s > 0
	% Chebyshew system
	yy = a * sqrt( 1 - xx.^2 / b^2 ) ;
else
	% Bessel system
	yy = b * sqrt( 1 - ( xx - c ).^2 / a^2 ) ;
end

xx = [ xx, xx( length(xx)-1 : -1 : 1 ) ] ;
yy = [ yy, -yy( length(yy)-1 : -1 : 1 ) ] ;
E = [xx(:), yy(:) ] ;

if nargin == 2
	plot( real(p), imag(p), '*g', xx, yy, '-r' )
	axis('square') ;
	ax = ceil( 2 * max( abs( [ imag( p(:) ) ; real( p(:) ) ] ) ) ) / 2 ;
	if tx
		axis([ -2*ax, 0, -ax, ax ]) ;
	end
	drawnow ;
	if test
		pause
	end
	if tx
		axis ;
	end
	axis('normal') ;
end
A = [ exc, a, b, x0 ] ;

if test
	% disp( '     exc      a         b        x0' )
	% disp([ exc, a, b, x0 ] )
	% disp(' ')
	disp([ xx(1),xx(nx) ])
	disp([ yy(1),yy(nx) ])
end
