function fig65(m,N)
% Fig. 6.5.
%	Impulse response calculated from a normal and windowed
%	1st-order frequency response.

% RXon, 000215

[z,p]=buttap(1);
if nargin < 2
	N=256;
end
if nargin < 1
	m=8;
end

w=(0:1:N-1)/m;

W= cos( (pi/2)*(0:1:N-1)/(N-1) ).^2 ;

F=freqw(z,p,w);

I1=2*real(fft(conj(F)))-1;
I1(1)=0;
I1=I1/max(I1);

I2=2*real(fft(conj(F.*W)))-1;
I2(1)=0;
I2(2)=I2(2)-2*pi*(m+1)/(N-1);
I2=I2/max(I2);


% ----------------------------------------------------------
% ----- ????????? ------
% ----------------------------------------------------------
% delta_t = 1 / ( 2 * pi * f_sampling )
% f_sampling = 2 * f_Nyquist
% f_Nyquist = f_max ;
% f_max = N / m ;
% ????? or f_max = (N-1) / m ;

% T = 1 / ( 2 * pi * delta_f ) ;
% delta_f = 1 / m	--> T == m / ( 2 * pi ) ;
% t = T * (0:1:N-1) / N ;
% ----------------------------------------------------------

delta_t = 2 * pi * m / (N-1) ;

t = delta_t * (0:1:N-1) ;

Id=exp(-t);
Id=[0, Id(1:N-1)];

x=max(find(t<=10));

figure;
plot(t(1:x),Id(1:x),'-r',t(1:x),I1(1:x),'-b',t(1:x),I2(1:x),'-k')

figure;
plot(t(1:x),I1(1:x)-Id(1:x),'-b',t(1:x),I2(1:x)-Id(1:x),'-k')


