function eran(x,k,N,m,o)
% ERAN	Error Analysis for the impulse- and step-response calculation using FFT.
%
%	Call :		eran(x,k,N,m,o);
%
%	where :	x --> Butterworth system order.        Default value :   1
%				k --> error plot amplification factor. Default value : 100
%				N --> vector length.                   Default value : 256
%				m --> frequency normalization.         Default value :   8
%				o --> window function type selection.  Default value :   2
%       				Available windows :		0) Hanning
%							   						1) Blackmann-Harris
%						 							2) Hamming
%

% RXon, 000326

if nargin < 5
	o=2;
end
if nargin < 4
	m=8;
end
if nargin < 3
	N=256;
end
if nargin < 2
	k=100;
end
if nargin < 1
	x=1;
end

[z,p]=buttap(x);

w=(0:1:N-1)/m;

dt=2*pi*m/N;
t=dt*(0:1:N-1);

F=freqw(z,p,w);

if o == 0
	% right-half Hanning window
	W=0.5*(1+cos(pi*(0:1:N-1)/(N-1)));
elseif o == 1
	% right-half Blackman-Harris window
	W=(.42 - .5*cos(2*pi*(N:2*N-1)/(2*N-1)) + .08*cos(4*pi*(N:2*N-1)/(2*N-1)));
else
	% right-half Hamming window
	W=0.54 - 0.46*cos(2*pi*(N:2*N-1)/(2*N-1));
end

In=(2*real(fft(conj(F)))-1)/N;
Iw=(2*real(fft(conj(F.*W)))-1)/N;

if x == 1
	a=0.905;
	e1n=dt*a-In(1);
	e1w=dt-Iw(1);
	In(1)=dt*a;
	Iw(1)=dt;
	In=In*(1/(1+e1n));
	Iw=Iw*(1/(1+e1w));
	% Ir=dt*exp(-t);
	Ir=exp(-t);
	Ir=Ir/sum(Ir);
else
	Ir=tdr(z,p,t,'n');
end

% q=31;
q=1+(4+2*x)*round(N/(2*pi*m));

En=k*abs((In-Ir)/max(Ir));
Ew=k*abs((Iw-Ir)/max(Ir));

% figh=1;
% figure(figh)
% plot( t(1:q), Ir(1:q), '-r', ...
%       t(1:q), In(1:q), '-g', ...
%       t(1:q), Iw(1:q), '-b', ...
%       t(1:q), En(1:q), '-c', ...
%       t(1:q), Ew(1:q), '-m')

Un=In/(0.9085*dt);
Uw=Iw/(0.9085*dt);
Ur=Ir/(0.9085*dt);
En=k*abs((Un-Ur)/max(Ur));
Ew=k*abs((Uw-Ur)/max(Ur));

figh=0;
figure(figh+1)
plot( t(1:q), Ur(1:q), '-r', ...
      t(1:q), Un(1:q), '-g', ...
      t(1:q), Uw(1:q), '-b', ...
      t(1:q), En(1:q), '-c', ...
      t(1:q), Ew(1:q), '-m')

title(['Fig.6.5.',num2str(2*x-1),'.: Impulse resp. and error - ',num2str(x),'-order system']);
xlabel('Normalized Time');
ylabel(['Amplitude and error*', num2str(k)]);

tx=2+(x-1);
ty=0.75;
dty=0.07;
dd=1;
if x > 1
	dd=2;
end

text( tx, ty/dd,          'Ir - Reference response');
text( tx, (ty-dty)/dd,    'Iw - Impulse r. from windowed f.r.');
text( tx, (ty-2*dty)/dd,  'In - Impulse r. from normal freq.r.');
text( tx, (ty-4*dty)/dd, ['En - Error: abs(In-Ir)*', num2str(k)]);
text( tx, (ty-5*dty)/dd, ['Ew - Error: abs(Iw-Ir)*', num2str(k)]);
if x == 1
	text( 0.4, Ur(max(find(t<=0.4)))+0.5*dty/dd, 'Ir,IW');
	text( 0.4, Un(max(find(t<=0.4)))-2*dty/dd,   'In');
	text( 0.4, En(max(find(t<=0.4)))+0.5*dty/dd, 'En');
	text( 0.4, Ew(max(find(t<=0.4)))+0.5*dty/dd, 'Ew');
else
	text( 0.4, Ur(max(find(t<=0.4)))+0.5*dty/dd, 'Ir,IW');
	text( 0.4, Un(max(find(t<=0.4)))-2*dty/dd,   'In');
	text( 0.4, En(max(find(t<=0.4)))+0.5*dty/dd, 'En');
	text( 0.4, Ew(max(find(t<=0.4)))+0.5*dty/dd, 'Ew');
end


Sn=cumsum([0,In(1:N-1)]);
Sw=cumsum([0,Iw(1:N-1)]);
if x > 1
	Sn=(Sn+cumsum(In))/2;
	Sn(1)=0;

	Sw=(Sw+cumsum(Iw))/2;
	Sw(1)=0;
end

if x == 1
	Sr=1-exp(-t);
else
	Sr=tdr(z,p,t,'s');
	% Sr=cumsum([0, Ir(1:N-1)]);
	% Sr=(Sr+cumsum(Ir))/2;
	% Sr(1)=0;
end

Fn=k*abs((Sn-Sr)/max(Sr));
Fw=k*abs((Sw-Sr)/max(Sr));

figure(figh+2)
plot( t(1:q), Sr(1:q), '-r', ...
      t(1:q), Sn(1:q), '-g', ...
      t(1:q), Sw(1:q), '-b', ...
      t(1:q), Fn(1:q), '-c', ...
      t(1:q), Fw(1:q), '-m')

title(['Fig.6.5.',num2str(2*x),'.: Step resp. and error - ',num2str(x),'-order system']);
xlabel('Normalized Time');
ylabel(['Amplitude and error*', num2str(k)]);
text( tx, ty,        'Sr - Reference response');
text( tx, ty-dty,    'Sw - Step r. from windowed f.r.');
text( tx, ty-2*dty,  'Sn - Step r. from normal freq.r.');
text( tx, ty-4*dty, ['En - Error: abs(Sn-Sr)*', num2str(k)]);
text( tx, ty-5*dty, ['Ew - Error: abs(Sw-Sr)*', num2str(k)]);
if x == 1
	text( 0.8, Sr(max(find(t<=0.8)))+3.5*dty/dd, 'Sw,Sr');
	text( 0.8, Sn(max(find(t<=0.8)))-0.5*dty/dd, 'Sn');
	text( 0.8, Fn(max(find(t<=0.8)))+0.5*dty/dd, 'En');
	text( 0.8, Fw(max(find(t<=0.8)))+0.5*dty/dd, 'Ew');
else
	text( 0.8, Sr(max(find(t<=0.8)))+3.5*dty/dd, 'Sw,Sr');
	text( 0.8, Sn(max(find(t<=0.8)))-0.5*dty/dd, 'Sn');
	text( 0.8, Fn(max(find(t<=0.8)))+0.5*dty/dd, 'En');
	text( 0.8, Fw(max(find(t<=0.8)))+0.5*dty/dd, 'Ew');
end
