function fig632
% FIG632 : Bessel-Thomson poles for systems of 2nd to 9th order

% plot( [-2,6], [0,0], '-g', [0,0], [-4,4], '-g' )     
plot( [-7,18], [0,0], '-k', [0,0], [-11,11], '-k' )
% axis equal square ;
axis equal ;
hold on
for k = 9:-1:1
	[z,p]=bestap(k,'t');
	[E,A]=efitpar(p) ;
	if k == 1
		plot(E(:,1),E(:,2),'-k',real(p),imag(p),'*r')
	else
		plot(E(:,1),E(:,2),'-b',real(p),imag(p),'*r')
	end
	% disp(['--> ', num2str(k),' ..... ', num2str(A(1))]);
end
xlabel( '\Re\{\its\rm\}' )
ylabel( '\Im\{\its\rm\}' )
% title( 'Fig.6.6.2. :  Bessel-Thomson poles (2nd to 9th-order systems)' )
text( 0.25, 1.5, '1' );
text( 0.25, 3, '2' );
text( 0.25, 10, '9' );
axis([-7,18,-11,11]);
