function fig653
% FIG653 ... Ch.6 fig. 6.3.
%	The "Negative-Frequency" Concept explained.
% ******************************************
% * Note:  This figure is obsolete.        *
% *       Replaced by an *.AI drawing.     *
% ******************************************

% RXon, 000215

phi = pi * ( 0 : 1 : 360 ) / 180 ;
beta = 30 * pi / 180 ;
r=0.5;

figure ;
% unit circle :
plot( sin(phi), cos(phi), '-b',...
      [-1, 1], [0, 0], '-k',...
      [0, 0], [-1, 1], '-k')
axis('square')
% hold on

w1 = 1.5 ;
% main phasor :
vector( [0, 0, cos(beta), sin(beta)], 'r', w1 ) ;

% its sine :
vector( [0, 0, 0, sin(beta)], 'r', w1 ) ;
vector( [cos(beta), 0, cos(beta), sin(beta)], 'r', w1 ) ;

% its cosine :
vector( [0, 0, cos(beta), 0], 'r', w1 ) ;

linh=line( [ 0, cos(beta) ], [ sin(beta), sin(beta) ] ) ;
set( linh, 'Color', 'r', 'Linestyle', '--' ) ;

w2 = 1.0 ;
% complement half-amplitude phasor pair :
% counter-clockwise (positive) rotating :
vector( [0, 0, r*cos(beta), r*sin(beta)], 'g', w2 ) ;

% clockwise (negative) rotating :
vector( [0, 0, r*cos(-beta), r*sin(-beta)], 'g', w2 ) ;

% negative half-phasor transfered :
vector( [r*cos(beta), r*sin(beta), cos(beta), 0], 'g', w2 ) ;

% positive half-phasor transfered :
vector( [r*cos(-beta), r*sin(-beta), cos(-beta), 0], 'g', w2 ) ;

% inverted negative half-phasor transfered :
vector( [r*cos(beta), r*sin(beta), 0, sin(beta) ], 'g', w2 ) ;

% rot.dir :
hold on
plot( 0.3*cos(phi(1:31)), 0.3*sin(phi(1:31)), '-b', ...
   0.3*cos(phi(361:-1:330)), 0.3*sin(phi(361:-1:330)), '-b', ...
   0.3*cos(phi(31))*[1.03,1,1.14,1.08,1], 0.3*sin(phi(31))*[0.7,1,0.8,0.8,0.7], '-b', ...
   0.3*cos(phi(330))*[1.03,1,1.14,1.08,1], 0.3*sin(phi(330))*[0.7,1,0.8,0.8,0.7], '-b' )

text( -0.05, -0.05, '0' ) ;
text( cos(beta), 0.05+sin(beta), 'A' ) ;
text( cos(beta), -0.05, 'B' ) ;
text( r*cos(beta)-0.05, 0.05+r*sin(beta), 'C' ) ;
text( r*cos(beta), -0.05+r*sin(-beta), 'D' ) ;
text( 0.05, 0.05 + sin(beta), 'E' ) ;
text( -0.9, 1.1, 'Fig. 6.3. : "Negative-Frequency" Explained' )
hold off