function fig654
% FIG654		Window example for 1st-order system.
%				Window is Hamming.

% RXon, 000215

N=256;
m=8;
z=[];
p=-1;
w=(0:1:N-1)/m;

F=freqw(z,p,w);

% Hanning window
% W=(1+cos( (pi/2)*(0:1:N-1)/(N-1) ) )/2 ;

% Hamming window
% W=hamming(2*N);
% W=W(N+1:2*N).';
W=0.54-0.46*cos(2*pi*(N+1:1:2*N)/(2*N));

plot(w,abs(F),'-r',w,W,'-c',w,abs(W.*F),'-m')
xlabel('Frequency [w=(0:1:255)/8]')
% title('Fig. 6.5.4. : Windowing of 1st-order system magnitude' )
text( 10, 0.8, 'W (Hamming window)' ) ;
text( 10, 0.15, 'abs(F(jw))' ) ;
text( 2, 0.05, 'abs(W*F(jw))' ) ;
