function fig65a
% Fig. 6.5.1-2
%	Bessel-Thomson systems from 1st to 10th order.
%	Impulse and step responses.

figure(1);
w=(0:1:255)/2;
for k = 1:2
	subplot(2,1,k);
	for N = 1:1:10
		[z,p]=bestap(N,'n');
		H=freqw(z,p,w);
		[S,I,t]=tresp(H,w);
		x=min( find( t > 7 ) ) ;
		t=t(1:x-1);
		I=I(1:x-1);
		S=S(1:x-1);
		R=[I(:), S(:)];
		plot(t,R(:,k),'-k')
		hold on
	end
end



