function sig_x
% SIG_X		Experimental.

% RXon, 000423

gn = 1	;			% gaussian noise addition flag

fs=2e+6;			% sampling frequency
fN=fs/2;			% Nyquist frequiency

f1=0.05e+6;		% main signal frequency
T1=5.73e-5;		% main signal decay-time
f2=0.73e+6;
% f2=1.81e+6;		% interfering signal frequiency
T2=5.73e-5;		% interfering signal decay-time

t=(0:1:500)/fs;	% time-scale
A=0.035*sin(2*pi*f1*t).*exp(-t/T1);		% main signal
B=0.250*sin(2*pi*f2*t).*exp(-t/T2);		% interfering signal

% shift the signal start by 100 samples :
A=[zeros(1,100), A(1:401)];
B=[zeros(1,100), B(1:401)];

M=0.005*randn(1,501);	% noise, normal distribution
T3=3e-6;			% noise spectrum shaping time constant
K=exp(-t/T3);	% high-pass system impulse response
K=K/sum(K);		% normalized for unity-gain
M=vcon(M,K);		% niose spectrum shaping in time-domain
M=M(1:501);

% test-plot of input signal and its components
figure(1);
% time-scale in us :
tu=1e+6;
if gn
	plot(t*tu,B,'-b',t*tu,A+0.25,'-r',t*tu,M-0.25,'-g',t*tu,A+B+M-0.4,'-k')
else
	plot(t*tu,B,'-b',t*tu,A+0.25,'-r','-g',t*tu,A+B-0.4,'-k')
end
xlabel( 'Time[us]' )
title( 'Input signal and its components' )

% 13th-order Bessel system construction
Bws=1.73;
[z,p13]=bestap(13,'a');
p13=sort(p13);
f7a=fN/10^( ( log10( ( (2^12) )^2 - 1 ) ) / ( 2 * 7 ) ) ;
% disp(['   f7a = ', num2str( f7a*1e-3 ), ' kHz']),pause
p13=p13*f7a*Bws;

% the 13th-order system is broken into a 7th-order analog
% and a 6th-order digital part :
p7=p13([1,4,5,8,9,12,13]);
p6=p13([2,3,6,7,10,11]);

% impulse responses
i7=atdr(z,p7,t(1:101),'n');
i6=atdr(z,p6,t(1:101),'n');

% test-plot
figure(2)
plot(t(1:101)*tu,i7,'-r',t(1:101)*tu,i6,'-b')
xlabel( 'Time [us]' )
title( '7th- and 6th-order system impulse response' )

% analog system response to input signal
if gn
	C=vcon(A+B+M,i7);
else
	C=vcon(A+B,i7);
end
C=C(1:501);

% digital system response to analog output
D=vcon(C,i6);
D=D(1:501);

% test-plot
figure(3)
plot(t*tu,C,'-r',t*tu,D,'-b')
xlabel( 'Time [us]' )
title( 'Analog and total A+D system signal output' )

% frequency-scale for spectrum analysis, normalized to Nyquist freq.
f=( 1/max(t) : 1/max(t) : fs )/fN ;

% transform signals to spectra :
E=fft(C);
F=fft(D);
if gn
	G=fft(A+B+M);
else
	G=fft(A+B);
end

lhs = 1 ;
if lhs
	% left-half spectra
	f = f(1:250);
	E=20*log10(abs(E(1:250)));
	F=20*log10(abs(F(1:250)));
	G=20*log10(abs(G(1:250)));
else
	% full spectra :
	E=20*log10(abs(E(1:500)));
	F=20*log10(abs(F(1:500)));
	G=20*log10(abs(G(1:500)));
end

% plot spectra :
figure(4)
plot(f,E,'-r',f,F,'-b',f,G,'-g')
xlabel( 'Frequency, normalized to Nyquist (f/fN) [MHz]' )
title( 'Input, anlog-output and processed output spectra' )
