function vector(M,cstr,lw)
% VECTOR Vector draw function. Draws vectors on the current plot.
%	Call :
%		vector( M, cstr, lw ) ;
%	where:
%		M --> a 4 or 6 column matrix of vector coordinates :
%					
%			M = [ x11, y11 {, z11}, x12, y12 {, z12} ; ...
%			      x21, y21 {, z21}, x22, y22 {, z22} ; ...
%			      .................................. ; ...
%			      xN1, yN1 {, zN1}, xN2, yN2 {, zN2} ] ;
%
%			The vector is drawn from [xi1, yi1 {, zi1}] to
%			[xi2, yi2 {, zi2}], where a small arrow is added.
%					 
%		cstr --> plotting color and style string, '-k' by default
%		  lw --> line width, 1.5 by default

% RXon 000307

if nargin < 3
	lw = 1.5 ;
end
if nargin < 2
	cstr = 'k' ;
end

[row, col] = size( M ) ;

axh = gca ;
axv = axis ;
nxv = length(axv) ;
if ( col ~= nxv )
	error( ['The matrix of vector coordinates must have ', num2str(nxv), ' columns !'] ) ;
end
ptd = nxv/2 ;

% axv = [ xmin, xmax, ymin, ymax {, zmin, zmax} ] ;
a = ( axv(2) - axv(1) )/( axv(4) - axv(3) ) ;
b = 0 ;
if nxv > 4
	b = ( axv(2) - axv(1) )/( axv(6) - axv(5) ) ;
end 
% axis diagonal :
D = sqrt( sum( ( axv( 2:2:nxv ) - axv( 1:2:nxv-1 ) ).^2 ) ) ;
% arrow-head size :
P = D/33 ;
% arrow-head angle :
% rho = 7*pi/8 ;
rho = 15*pi/16 ;
% mr = 2/3 ;
mr = 7/8 ;

% temporarily modify the NextPlot property :
nextplotstr = get( axh, 'NextPlot' ) ;
set( axh, 'NextPlot', 'add' ) ;

for k = 1:row
	R = sqrt( sum( ( M(k,1+ptd:1:nxv) - M(k,1:1:ptd) ).^2 ) ) ;
	m = 1 ;
	% if R < 2*P
	%	m = R/3 ;
	% end

	if ( M(k,1+ptd) == M(k,1) )
		% d = sign( M(k,2+ptd) - M(k,2) ) ;
		d = 1 ;
		az = sign( M(k,2+ptd) - M(k,2) ) * pi / 2 ;
	else
		d = sign( M(k,1+ptd) - M(k,1) ) ;
		az = atan( ( M(k,2+ptd) - M(k,2) )/( M(k,1+ptd) - M(k,1) ) ) ;
	end

	if ptd == 2
		aw = [  M(k,1+ptd),			M(k,2+ptd)			; ...
			M(k,1+ptd)+m*d*P*cos(az+rho),	M(k,2+ptd)+m*d*P*sin(az+rho)	; ...
			M(k,1+ptd)-mr*m*d*P*cos(az),	M(k,2+ptd)-mr*m*d*P*sin(az)	; ...
			M(k,1+ptd)+m*d*P*cos(az-rho),	M(k,2+ptd)+m*d*P*sin(az-rho)	; ...
			M(k,1+ptd),			M(k,2+ptd)			] ;
		% poh = plot( [ M(k,1) ; aw(:,1) ], [ M(k,2) ; aw(:,2) ], cstr ) ;
		poh = patch( [ M(k,1) ; aw(:,1) ; M(k,1) ], [ M(k,2) ; aw(:,2) ; M(k,2) ], cstr ) ;

		for h = 1 : length(poh)
			set( poh(h), 'LineWidth', lw, 'EdgeColor', cstr ) ;
		end
	end

	if ptd == 3
		if ( M(k,1+ptd) == M(k,1) )
			el = sign( M(k,3+ptd) - M(k,3) ) * pi / 2 ;
		else
			el = atan( ( M(k,3+ptd) - M(k,3) )/( M(k,1+ptd) - M(k,1) ) ) ;
		end
		% !!! aw should be [ 5 -by- 3 ] matrix !!!
		aw = [  M(k,1+ptd),		  M(k,2+ptd)		   ; ...
			M(k,1+ptd)+P*cos(az+rho), M(k,2+ptd)+P*sin(az+rho) ; ...
			M(k,1+ptd)+mr*P*cos(az), M(k,2+ptd)+mr*P*sin(az) ; ...
			M(k,1+ptd)+P*cos(az-rho), M(k,2+ptd)+P*sin(az-rho) ; ...
			M(k,1+ptd),		  M(k,2+ptd)		   ] ;
		% poh = plot3( [ M(k,1) ; aw(:,1) ], [ M(k,2) ; aw(:,2) ], [ M(k,3) ; aw(:,3) ], cstr ) ;
		poh = patch( [ M(k,1) ; aw(:,1) ; M(k,1) ], [ M(k,2) ; aw(:,2) ; M(k,2) ], [ M(k,3) ; aw(:,3) ; M(k,3) ], cstr ) ;
		for h = 1 : length(poh)
			set( poh(h), 'LineWidth', lw , 'EdgeColor', cstr ) ;
		end
	end
end

set( axh, 'NextPlot', nextplotstr ) ;
