function fig61mv4
% Fig. 6.1.X
% Complete 5th-order Butterworth system representation.

% RXon, 890112
% Last revision (Matlab-IV) : 000130
% Revision Matlab-V : 000812

% get Matlab version number :
matver=version;
matver=str2num(matver(1));

[z,p]=buttap(5);	% a 5th order Butterworth system zeros and poles
[row,col]=size(p);

% ----- polar-coordinates pole loci ----- ;
figh=figure(1) ;
A=zeros(row,col);
B=atan(imag(p)./real(p));
C=-abs(p);
Q=[A,B];
Q=Q.';
Q=Q(:);
R=[A,C];
R=R.';
R=R(:);
polar( B, C, '*r')
hold on
polar( Q, R, '-r')
hold off
grid
if matver == 4
   text(-0.9,-1.25,['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Poles'])
else
   xlabel(['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Poles'])
end
text( 1.2, 0.0, 'Real(s)' )
text( -0.2, 1.25, 'Imag(s)' )


% ----- cartesian-coordinates pole loci ----- ;
figh=figure(figh+1) ;
P=[p(:).'; zeros(size( p(:).' ) )];
P=P(:);
theta=(0:pi/180:2*pi);
if matver > 3
   fill( [ -2, 0, 0, -2 -2 ], [ -2, -2, 2, 2, -2 ], [ 0.82, 0.82, 0.82 ] ) ;
   hold on
   axis('manual')
end
plot([-1.99,1.99],[0,0],'-k',...
     [0,0],[-1.99,1.99],'-k',...
     sin(0:pi/180:2*pi),cos(0:pi/180:2*pi),'-b',...
     real(P),imag(P),'-r',...
     real(p),imag(p),'*r')
axis('square')
axis([-2,2,-2,2]);
for kx = 1 : length(p)
   text( real(p(kx)) - 0.3, imag(p(kx)) + sign(imag(p(kx))) * 0.3, ['p', num2str(kx)] ) ;
end
if matver > 3
	axh=gca;
	set(axh,'XTickMode','Manual','XTickLabelMode','Manual');
	set(axh,'YTickMode','Manual','YTickLabelMode','Manual');
	set(axh,'XTick',[-2,-1.5,-1,-0.5,0,0.5,1,1.5,2]);
	set(axh,'YTick',[-2,-1.5,-1,-0.5,0,0.5,1,1.5,2]);
	if matver == 4
   	set(axh,'XTickLabels',['-2.0';'-1.5';'-1.0';'-0.5';' 0.0';' 0.5';' 1.0';' 1.5';' 2.0']);
		set(axh,'YTickLabels',['-2.0';'-1.5';'-1.0';'-0.5';' 0.0';' 0.5';' 1.0';' 1.5';' 2.0']);
	else   
	   set(axh,'XTickLabel',['-2.0';'-1.5';'-1.0';'-0.5';' 0.0';' 0.5';' 1.0';' 1.5';' 2.0']);
		set(axh,'YTickLabel',['-2.0';'-1.5';'-1.0';'-0.5';' 0.0';' 0.5';' 1.0';' 1.5';' 2.0']);
   end
end   
text(1.2,0.20,'Real(s)')
text(0.1,1.75,'Imag(s)')
if matver == 4
   text(-1.8,2.2,['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Poles'])
else
   title(['Fig. 6.1.',num2str(figh),'1. :  5th-order Butterworth Poles'])
end

% ----- 3-D Magnitude over the s-plane ----- ;
figh=figure(figh+1) ;
% xyz( zeros, poles, sigma, omega, hight, resolution, grapgtype ) ;
% graphtype : 1=mesh, 2=waterfall, 3=surf, 4=surfl ;
xyz( z, p, -2, 2, 12, 80, 4 ) ;
axis([-2,0,-2,2,0,12]);
if matver > 3
	axh=gca;
	if matver > 4
   	set(axh,'ZTick',[0,3,6,9,12],'ZTickLabel',[' 0';' 3';' 6';' 9';'12']);
	else   
   	set(axh,'ZTick',[0,3,6,9,12],'ZTickLabels',[' 0';' 3';' 6';' 9';'12']);
   end   
end   

% xlabel( 'sigma=real(s)' )
if matver > 3
	txh=text(-1,-3,-1,'x');
	% display greek 'sigma' from the BCSYMB (WinEXP) font, instead of x :
	% set(txh,'FontName','BCSYMB','FontSize',16,'String',setstr(53));
	% display greek 'sigma' from the Symbol font, instead of x :
	% set(txh,'FontName','Symbol','FontSize',10,'String',setstr(83));
	set(txh,'FontName','Symbol','FontSize',10,'String',char('s'));
   text(-1,-3,-1,'   = \Re\{{\its}\}')
	% text(-1,-3,-1,'{\it\sigma} = \Re\{{\its}\}','FontSize',16)

else
   xlabel('real(s)');
end   

% ylabel( 'jw =j*imag(s)' )
if matver > 3
	txh=text(0,0,-2,'  x');
	% display greek 'omega' from BCSYMB (WinEXP) font, instead of x :
	% keep the spaces for correct alignment !
	% set(txh,'FontName','BCSYMB','FontSize',16,'String',['  ',setstr(61)]);
	% display greek 'omega' from Symbol font, instead of x :
	% set(txh,'FontName','Symbol','FontSize',10,'String',['  ',setstr(87)]);
	set(txh,'FontName','Symbol','FontSize',10,'String',['  ',char('w')]);
   text(0,0,-2,'\itj\rm    = \itj\Im\rm\{{\its}\}')
else
   ylabel('j*imag(s)')
end   

zlabel( '|\itF\rm(\its\rm)|' )

if matver > 4
   title( ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth s-Plane Magnitude'] )
else   
   text(-1.8,-1.8,14, ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth s-Plane Magnitude'] )
end   


% ----- 3-D Helix, complex-frequency complex response ----- ;  
figh=figure(figh+1) ;
jw=(-3:0.01:3);			% 601 frequency points, pos. and neg., linear scale
a1=ones(length(jw),1) ;
G=freqw(z,p,jw(301:601));	% 301 points of complex frequency response
G=[real(G(301:-1:2))-j*imag(G(301:-1:2)), G];	% full +/-3 freq.range
plot3([-3, 3], [0, 0], [0, 0], '-g',...
      [0, 0], [-1.5, 1.5], [0, 0], '-b',...
      [0, 0], [0, 0], [-1.5, 1.5], '-k',...
		[-3,-3],[-1.5,-1.5],[-1.5,1.5], '-k',...
      jw, real(G), imag(G), '-r',...
		-3*a1, real(G), imag(G), '-k',...
		jw, 1.5*a1, imag(G), '-k',...
		jw, real(G), -1.5*a1, '-k',...
      0, 1, 0, 'ok')
% view(-40,20);
view( 55,15 );
axis([-3,3,-1.5,1.5,-1.5,1.5]) ;
axis equal ;
grid ;
if matver > 3
	axh=gca ;
	if matver > 4
		set(axh,'XTick',[-3,-2,-1,0,1,2,3],'XTickLabel',['-3';'-2';'-1';' 0';' 1';' 2';' 3']);
	   set(axh,'YTick',[-1.5,-1,-0.5,0,0.5,1,1.5],'YTickLabel',['-1.5';' -1 ';'-0.5';'  0 ';' 0.5';'  1 ';' 1.5']);
	else   
		set(axh,'XTick',[-3,-2,-1,0,1,2,3],'XTickLabels',['-3';'-2';'-1';' 0';' 1';' 2';' 3']);
	   set(axh,'YTick',[-1.5,-1,-0.5,0,0.5,1,1.5],'YTickLabels',['-1.5';' -1 ';'-0.5';'  0 ';' 0.5';'  1 ';' 1.5']);
   end
end   

% text(3, 0.25, 0.1, 'j*omega')
if matver > 3
	txh=text(3,0.25,0.1, '  x');
	% display greek 'omega' from BCSYMB (WinEXP) font, instead of x :
	set(txh,'FontName','BCSYMB','FontSize',16,'String',['  ',setstr(61)]); % display 'omega'
   text(3,0.25,0.1,'j    ')
else
   text(3,0.25,0.1,'j*w')
end

text( -1.5, 1.5, 0.25, 'Real(F)' )
text(  0.1, 0.0, 1.35, 'Imag(F)' )

if matver == 4
   text(-3.0,2.0,1.8,['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Complex-Frequency Response'])
else   
   title(['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Complex-Frequency Response'])
end   


% ----- Bode-plot : single-side complex-frequency complex response ----- ;
figh=figure(figh+1) ;
w=logspace(-3,1,601);	% 601 frequency points, equally spaced in
								% 3-decade log scale from 0.01 to 10 ;
H=freqw(z,p,w);	% 601 points of complex frequency response ;
Q=(pi/2)+(-0.2:0.02:pi/3);
plot([-1,1], [0,0], '-k',...
     [0,0], [-1,1], '-k',...
     0.25*sin(Q), 0.25*cos(Q), '-b',...
     1, 0, 'ob',...
     -0.5, 0.5, 'ob',...
     0, 0, 'ob',...
     [0,real(H(350))], [0,imag(H(350))], '-b',...
     real(H), imag(H), '-r')
axis('square')
axis('manual')
hold on
text(0.4, 0.07, 'Real(F)');
text(0.05, 0.8, 'Imag(F)');
if matver > 3
   txh=text( 0.05, -0.1, 'x  ' );
   % display greek 'phi' from BCSYMB (WinEXP) font, istead of x :
   set( txh, 'FontName', 'BCSYMB', 'FontSize', 16, 'String', setstr(58) ) ;
   text( 0.05, -0.1, '   = atan(Im(F)/Re(F))' );
else
   text( 0.2, -0.1, 'atan(Im(F)/Re(F))' );
end

text( 0.3, -0.5, 'M=abs(F)' );

% text( 1.03, 0.1, 'w=0' );
if matver > 3
   txh=text(1.03,0.1, 'x ');
	% display greek 'omega' from BCSYMB (WinEXP) font, instead of x :
	set( txh,'FontName','BCSYMB','FontSize',16,'String',setstr(61) );
   text( 1.03, 0.1, '   = 0');
else
   text( 1.03, 0.1, 'w=0');
end   

% text( -0.75, 0.55, 'w=1' );
if matver > 3
	txh=text( -0.75, 0.55, 'x ');
	% display greek 'omega' from BCSYMB (WinEXP) font, instead of x :
	set( txh,'FontName','BCSYMB','FontSize',16,'String',setstr(61) );
   text( -0.75, 0.55, '   = 1');
else
   text( -0.75, 0.55, 'w=1');
end

% text( -0.3, -0.15, 'w=inf' )
if matver > 3
	txh=text( -0.3, 0.06, 'x ');
	% display greek 'omega' from BCSYMB (WinEXP) font, instead of x :
	set( txh,'FontName','BCSYMB','FontSize',16,'String',setstr(61) );
	txh=text( -0.3, 0.06, '     x ');
	% display 'infinity' from BCSYMA (WinEXP) font, instead of x :
	set( txh,'FontName','BCSYMA','FontSize',16,'String',['     ', setstr(95)] );
   text( -0.3, 0.05, '   =');
else
   text( -0.3, 0.05, 'w=inf');
end

if matver == 4
   text(-1,1.05,['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Bode-Plot'])
else   
   title(['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Bode-Plot'])
end   
hold off
axis('auto')


% ----- Lin-lin Magnitude plot ----- ;
figh=figure(figh+1) ;
M=abs(H);		% magnitude
ix=max(find(w<=3));	 % limit the frequecy scale to 3.
% display M in lin-lin plot :
plot([w(1),w(ix)],[0.707,0.707],'-k',...
     [1,1],[0,1.19],'-k',...
     w(1:ix),M(1:ix),'-r')
  
text( 1.1, 0.74, '0.707' )
axis([0, 3, 0, 1.2]);
xlabel( 'Frequency' )
ylabel( 'Magnitude' )
if matver == 4
   text(0.2,1.25, ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Magnitude'] )
else   
   title( ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Magnitude'] )
end   


% ----- Nyquist plot : log10(f)-dB(M) ----- ; 
figh=figure(figh+1) ;
w=w(301:601);		% limit the frequency to -/+1decade
H=H(301:601);
M=abs(H);		% magnitude
% display M in dB vs. log-scale w
semilogx( w, 20*log10(M),'-r', [0.7, 1.4], [-3, -3], '-b', [1, 1], [0, -10], '-b' )
axis( [ 0.1, 10, -100, 0 ] ) ;
if matver > 3
	axh=gca;
	if matver > 4
   	set(axh,'XTickLabel',['0.1 ';'1.0 ';'10.0']);
	else   
   	set(axh,'XTickLabels',['0.1 ';'1.0 ';'10.0']);
   end
end

if matver == 4
   text( 1.2, -95, 'Frequency' )
else   
   xlabel( 'Frequency' )
end

text( 0.6, -6, '-3dB' )
text( 3, -40, 'Slope :' )
text( 3.5, -50, '-100dB/10f' )
ylabel( 'Magnitude [dB]' )

if matver == 4
   text(0.15,5, ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Magnitude'] )
else   
   title( ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Magnitude'] )
end   


% ----- Nyquist plot : phase angle ----- ;
figh=figure(figh+1) ;
phi=angle(H);		% phase response, modulo +/-pi
semilogx([min(w),max(w)],[pi,pi],'--b',...
         [min(w),max(w)],[-pi,-pi],'--b',...
         w,phi,'-r')
if matver > 3
	axh=gca;
	if matver > 4
   	set(axh,'XTickLabel',['0.1 ';'1.0 ';'10.0']);
	else   
      set(axh,'XTickLabels',['0.1 ';'1.0 ';'10.0']);
	end      
end   

if matver == 4
   text( 1.2, -3.6, 'Frequency' )
else   
   xlabel( 'Frequency' )
end

if matver > 3
	txh=text( max(w)/3, pi+0.25, '+pi' );
	% display greek 'pi' from BCSYMB (WinEXP) font, instead of +pi :
	set( txh,'FontName','BCSYMB','FontSize',16,'String',['  ',setstr(49)] );
	text( max(w)/3, pi+0.25, '+  ' );

	txh=text( max(w)/3, -pi+0.25, '-pi' );
	% display greek 'pi' from BCSYMB (WinEXP) font, instead of -pi :
	set( txh,'FontName','BCSYMB','FontSize',16,'String',['  ',setstr(49)] );
   text( max(w)/3, -pi+0.25, '-  ' );
else
	text( max(w)/3, pi+0.25, '+pi' );
   text( max(w)/3, -pi+0.25, '-pi' );
end

ylabel( 'Phase angle [rad]' )

if matver == 4
   text(0.15,4.4, ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Phase'] )
else
   title( ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Phase'] )
end   


% ----- phase angle unwrapped, in degrees ----- ;
figh=figure(figh+1) ;
% unwrap the phase :
alpha=ephd(phi);
% display alpha in linear degrees
semilogx(w,180*alpha/pi,'-r')
if matver > 3
	axh=gca;
	set(axh, 'YTick', [ -450, -360, -270, -180, -90, 0 ] ) ;
	if matver > 4
		set(axh, 'YTickLabel', [ '-450'; '-360'; '-270'; '-180'; ' -90'; '   0' ] ) ;
		set(axh,'XTickLabel',['0.1 ';'1.0 ';'10.0']);
   	xlabel( 'Frequency' )
	else   
		set(axh, 'YTickLabels', [ '-450'; '-360'; '-270'; '-180'; ' -90'; '   0' ] ) ;
		set(axh,'XTickLabels',['0.1 ';'1.0 ';'10.0']);
   	text( 1.2, -475, 'Frequency' )
   end
else
  	xlabel( 'Frequency' )
end

ylabel( 'Phase angle [degrees]' )

if matver > 4
   title( ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Unwrapped Phase'] )
else   
   text(0.15,20, ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Unwrapped Phase'] )
end   


% ----- group (envelope) time-delay ----- ;
figh=figure(figh+1) ;
tau=diff(alpha)./diff(w);		% time-delay
w=sqrt(w(2:1:301).*w(1:1:300));		% new w
semilogx(w,tau,'-r')			% plot
if matver > 3
	axh=gca;
	if matver > 4
   	set(axh,'XTickLabel',['0.1 ';'1.0 ';'10.0']);
	else   
   	set(axh,'XTickLabel',['0.1 ';'1.0 ';'10.0']);
   end   
end   

if matver == 4
   text( 1.2, -5.7, 'Frequency' )
else   
   xlabel( 'Frequency' )
end

ylabel( 'Time-Delay [s]' )

if matver == 4
   text(0.15,0.25, ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Envelope-Delay'] )
else
   title( ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Envelope-Delay'] )
end   


% ----- time-domain response : impulse and step function ----- ;
figh=figure(figh+1) ;
w=(0:1:255)/4;		% linear frequency vector
H=freqw(z,p,w);		% complex frequency response in new w ;
[I,t]=tresp(H,w,'i');	% impulse response
[S,t]=tresp(H,w,'s');	% step response
nt=min( find( t > 20 ) ) - 1 ;	% limit time to 25*Tnorm
t=t(1:nt);
I=I(1:nt);
S=S(1:nt);
plot( t, I, '-r', t, S, '-b' )
text(8,0.15, 'Impulse-Response' )
text(8,0.85, 'Step-Response' )
xlabel( 'Time [s]' )
ylabel( 'Amplitude' )
if matver == 4
   text(0,1.3, ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth in Time Domain'] )
else   
   title( ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth in Time Domain'] )
end
