function fig71
%FIG71	Generate Fig.7.1 - the convolution example for WBAmps, Part 7.
%
%	plot the 5th-order Butterworth impulse-response with a gated sinewave.

[z,p]=buttap(5);			% 5th-order Butterworth system
t=(0:1:500)/10;				% time vector
nt=length(t);

h=atdr(z,p,t(1:301),'i');	% system impulse-response
nh=length(h);

figure(1);
plot(t(1:nh),h)				% plot h vs t ;

								% x is the input signal : 25 zeros and
								% ??? points of sin(2*pi*t/T) ;
b=25;
T=2*pi/(1.35*w(m+1));		% sinewave frequency is 1.3*(system half-power bandwidth)
x=[zeros(1,b), sin(2*pi*t(1:nt-b)/T)];

								% plot h and x ;
figure(2);
plot( t(1:nh+b), [zeros(1,b), h], '-r', t, x, '-g')

y=vcon(h/sum(h),x);			% convolve x with h ;

								% plot convolution result
figure(3);
plot( t(1:nh+b), [zeros(1,b), h],'-r', ...
      t, x, '-g', ...
      t, y(1:nt), '-b' )
