function fig711
%FIG71	Generate Fig.7.1.1 - the convolution example for WBAmps, Part 7.
%
%	plot the 5th-order Butterworth impulse-response with a gated sinewave.

d=25;							% switch-on delay 25 time-samples
fh=1000;						% system half-power bandwidth
fs=1500;						% input signal frequency 1.5*(system hpbw)
t=(0:1:300)/(50*fh);		% time vector
nt=length(t);
								% make the input signal :
x=[zeros(1,d), sin(2*pi*t(1:nt-d)*fs)];

[z,p]=buttap(5);			% 5th-order Butterworth system
p=2*pi*p*fh;					% denormalize the poles

h=atdr(z,p,t(1:200),'n');	% system impulse-response
g=atdr(z,p,t(1:200),'i');
nh=length(h);

y=vcon(h,x);					% convolve x with h ;
								% h/sum(h) : normalize to unity gain

								% plot convolution result
% b=h*length(h)/(2*pi);
b=h*length(h)/(2*pi*fh*max(t(length(h))));
g=g/(2*pi*fh);
plot( t*fh, x, '-g', ...
      t(1:nh+d)*fh, [zeros(1,d), g]+0.01,'-m', ...
      t(1:nh+d)*fh, [zeros(1,d), b],'-r', ...
      t*fh, y(1:nt), '-b')
xlabel('Time [ms]')
