function fig714_2
%FIG714_2	Generate Fig.7.1.4.a,b,c for WBAmps, Part 7.
%	
%	Show spectrum analysis and multiplication in frequency domain
%	as a substitute for convolution.
%	Version-2 uses a spin-echo MRI example

% RXon, 010122

fh=1e+6;			% system bandwidth 
N=1024;			% total vector length ;
m=64/(2*pi*fh);	% frequency scaling factor
w=(0:1:N-1)/m;	% frequency vector ;

[z,p]=bestap(5,'n');		% 5rd-order Bessel system ;
p=p*2*pi*fh;		% half-power bandwidth is 1MHz ;
F=freqw(z,p,w);	% frequency response ;

dt=2*pi*m/N;		% delta-t ;
t=dt*(0:1:N-1);	% time vector ;

w1=1/(4.50*dt);	% input signal frequency ;
w2=1/(0.91*dt);	% input interference frequency ;
g=sin(w1*t);		% input function in time domain ;
ngw=360;
gw=gaussw(ngw,7);
g=[g(1:ngw).*gw, zeros(1,N-ngw)];
% g=[zeros(1,N/8), g(1:N-N/8)];
g=g+0.081*sin(w2*t);
rn=0.091*[0, diff([0,diff(randn(1,N))])];
g=g+rn;

figure(1)
x=max(find(t<=0.00006));
plot( t(1:x)*fh, g(1:x), '-g' )
xlabel('Time [\it\mu\rms]')
% axis([0, 0.06, -0.15, 0.15]);
% title('Input signal')

G=fft(g);			% G is spectrum of g ;

Y=F.*G;				% output spectrum ;
				% multiplication in frequency equals convolution in time ;

figure(2)
x=max(find(w<=5e+7));
M=max(abs(G));
plot( w(1:x)/(2*pi*fh), abs(G(1:x))/M, '-g', ...
      w(1:x)/(2*pi*fh), abs(F(1:x)), '-r', ...
      w(1:x)/(2*pi*fh), abs(Y(1:x))/M, '-b' )
xlabel('Frequency [MHz]'), ylabel('Normalized Magnitude');
% title('Magnitude Spectra')

y=2*(real(fft(conj(Y)))-1)/N;	% return to time domain and show result ;

figure(3)
% a=max(find(t<=0.000005));
a=1;
b=max(find(t<=0.000020));
plot( t(a:b)*fh, g(a:b), '-g',...
      t(a:b)*fh, y(a:b), '-b' )
xlabel('Time [\it\mu\rms]')
% axis([0.005, 0.025, -0.15, 0.15]);
% title('Input and Output Signals')

