function fig75
%FIG75	Generate Fig.7.5.x for the Part7 of the WBAmps.
%
%	This figures are for the system design example
%	n=[5,7,9].

% RXon, 000403

% ----------- frequency-domain analysis ----------------------- ;
N=301;
A=2^12;				% ADC resolution limit sets the attenuation
w0=1e+6;			% ADC bandwidth requirement, 1MHz = Nyquist frequency
w5=w0*10^(log10(A^2-1)/(2*5));
w7=w0*10^(log10(A^2-1)/(2*7));
w9=w0*10^(log10(A^2-1)/(2*9));
disp('     w5        w7       w9    [MHz]')
disp('-----------------------------------')
disp([w5, w7, w9]/w0)

w5=w0*w0/w5;
w7=w0*w0/w7;
w9=w0*w0/w9;
disp('     w5        w7       w9    [MHz]')
disp('-----------------------------------')
disp([w5, w7, w9]/w0)

w=logspace(4,6,N);	% frequency (1e+4 to 1e+6 in 301 log-scale steps)

[z5,p5]=bestap(5,'a');	% BesselThomson 'asymptote' normalized systems
[z7,p7]=bestap(7,'a');	% of order 5, 7 and 9 ;
[z9,p9]=bestap(9,'a');

p5=p5*w5;			% The poles are scaled-down so that all three
p7=p7*w7;			% responses have 1/A attenuation at w=1e+6.
p9=p9*w9;

F5=20*log10(abs(freqw(p5,w)));	% Calculate magnitudes in dB ;
F7=20*log10(abs(freqw(p7,w)));
F9=20*log10(abs(freqw(p9,w)));

figure(1)
% plot magnitudes in dB vs. log-scaled frequency
% and the -3dB reference level (see Fig.6.9) :
db3=-3.0103;
semilogx( 1e-3*w, F5, '-r', ...
	  1e-3*w, F7, '-g', ...
	  1e-3*w, F9, '-b', ...
	  1e-3*w0*[0.06, 0.3], [db3, db3], '-k', ...
          1e-3*w0*[0.01, 1], 20*log10(1/A)*[1, 1], '--k' )
axh=gca;
% xlh=get(axh,'XLabel');
set(axh,'XTickLabelMode','manual');
set(axh,'XTickLabel',['  10'; ' 100'; '1000']);
xlabel( 'Frequency [kHz]' )
ylabel( 'Attenuation' )

text( 1e-3*w0*0.06, -6, '-3dB' )
text( 1e-3*w0*0.02, -70, 'ADC resolution : -72dB' )
text( 1e-3*w0*0.013, -20, 'Fig. 7.5.1.:' )
text( 1e-3*w0*0.013, -24, 'Frequency-responses, normalized to' )
text( 1e-3*w0*0.013, -28, 'equal attenuation at Nyquist frequency' )

% compare the magnitudes with the -3dB level and
% find the index of the frequency limits:

m=abs(F5-db3);
x5=find(m==min(m));

m=abs(F7-db3);
x7=find(m==min(m));

m=abs(F9-db3);
x9=find(m==min(m));

w5h=w(x5);
w7h=w(x7);
w9h=w(x9);
text( 1e-3*w0*0.013, -52, 'Cut-off frequencies :' )
text( 1e-3*w0*0.02, -45, ['f5 = ', num2str( w5h*1e-3 ), ' kHz'])
text( 1e-3*w0*0.02, -41, ['f7 = ', num2str( w7h*1e-3 ), ' kHz'])
text( 1e-3*w0*0.02, -37, ['f9 = ', num2str( w9h*1e-3 ), ' kHz'])

% now display the cutoff frequencies :
disp('     w5h       w7h      w9h   [MHz]')
disp('-----------------------------------')
disp([w5, w7, w9]/w0)


% ----------- time-domain analysis ---------------------------- ;
fs=2*w0;		% sampling frequency
t=(0:1:N-1)/fs;		% time vector
xt=max(find(t<=1e-4));

S5=atdr(z5,p5,t,'s');	% Step responses
S7=atdr(z7,p7,t,'s');	% same time scale for all three responses
S9=atdr(z9,p9,t,'s');

figure(2)
% plot the step responses with the 0.1 and 0.9 reference levels :
ts=1e+4*t(1:xt);
x1=t([15, 30]);
x2=t([40 80]);
y10=[.1 .1];
y90=[.9 .9];
plot( t(1:xt)*w0, S5(1:xt), '-r', ...
      t(1:xt)*w0, S7(1:xt), '-g', ...
      t(1:xt)*w0, S9(1:xt), '-b', ...
      x1*w0,           y10,      '-k', ...
      x2*w0,           y90,      '-k' )
xlabel( 'Time [us]' )
text( 40, 0.70, 'Fig. 7.5.2.:' )
text( 40, 0.63, 'Step-responses of the normalized' )
text( 40, 0.56, 'systems of Fig. 7.5.1.' )
text( 40, 0.33, 'Rise-times :' )

x2=min(find(S5>=0.9));
x1=max(find(S5<=0.1));
Tr5=t(x2)-t(x1);
x2=min(find(S7>=0.9));
x1=max(find(S7<=0.1));
Tr7=t(x2)-t(x1);
x2=min(find(S9>=0.9));
x1=max(find(S9<=0.1));
Tr9=t(x2)-t(x1);
text( 40, 0.23, ['Tr5 = ', num2str(Tr5*w0), ' us'] )
text( 40, 0.16, ['Tr7 = ', num2str(Tr7*w0), ' us'] )
text( 40, 0.09, ['Tr9 = ', num2str(Tr9*w0), ' us'] )

% ----------- aliasing suppression analysis ------------------- ;
% new frequency vector(1e+5 to 1e+7 in 301 log-scale steps)
w=logspace(5,7,N);
SF=1.75;					% frequency shift factor
F70=20*log10(abs(freqw(z7,p7,w)));	% reference system
F71=20*log10(abs(freqw(z7,SF*p7,w)));	% half-octave shifted system

xw0=max(find(F70>=-80));
xw1=max(find(F71>=-80));
xwa=max(find(F71>=-72));
xwn=find(w==1e+6);

wa=w(xwn:xwa);		% w0 <= w <= w(F71==1/A)
F71A=F71(xwn:xwa);	% F71 > Nyquist fr.
F71AF=F71(xwa:-1:xwn);	% alias of F71A ------------------------------- ???

wa2=[wa; wa];	% shadowing under F71A
wa2=wa2(:).';
[r,c]=size(F71A);
F71A2=[-72*ones(r,c); F71A];
F71A2=F71A2(:).';

waf=2*w0-wa;		% alias frequency vector

waf2=[waf; waf];	% shadowing of F71AF
waf2=waf2(:).';
F71AF2=[-72*ones(r,c); F71A];
F71AF2=F71AF2(:).';

Fr=20*log10(1/A)-F71A;	% aliasing filter requirement

figure(3);
semilogx( w(1:xw0)/w0,     F70(1:xw0),           '-r' , ...
	  [w(1), w(N)]/w0, 20*log10(1/A)*[1, 1], '--k', ...
	  w(1:xw1)/w0,     F71(1:xw1),           '-b' , ...
	  wa2/w0,          F71A2,                '-b' , ...
	  waf2/w0,         F71AF2,               '-g' , ...
	  waf/w0,          F71A,                 '-g' , ...
	  waf/w0,          Fr,                   '-m' )
axh=gca;
% xlh=get(axh,'XLabel');
set(axh,'XTickLabelMode','manual');
set(axh,'XTickLabels',[' 0.1'; ' 1.0'; '10.0']);
xlabel( 'Frequency [MHz]' )
ylabel( 'Attenuation' )
text( 0.30, -25, 'F70' )
text( 0.53, -25, 'F71' )
text( 0.80, -20, 'Frq' )
text( 1.50, -56, 'Fa' )
text( 0.33, -60, 'Fs-Fa' )
text( 1.30, -5, 'Fig.7.5.3.: Alias band' )
text( 1.30, -9, 'suppression requirement')
