function fig711
%FIG711	Generate Fig.7.1.1 - the convolution example
%			for WBAmps, Part 7. Plot the 5th-order Butterworth
%			system response excited by a gated sinewave.

fh=1000;						% system half-power bandwidth, 1kHz
fs=1500;						% input signal frequency, 1.5kHz
[z,p]=buttap(5);			% 5th-order Butterworth system
p=2*pi*fh*p;					% denormalized system poles
t=(0:1:300)/(50*fh);		% time vector, 20us delta-t, 6ms range
nt=length(t);

h=atdr(z,p,t,'n');			% system impulse-response

d=25;							% switch-on delay 25 time-samples
								% make the input signal :
x=[zeros(1,d), sin(2*pi*fs*t(1:nt-d))];

y=vcon(h,x);					% convolve x with h ;

A=nt/(2*pi*fh*max(t));
								% plot convolution result
plot( t*fh, x, '-g', ...
      t*fh, [zeros(1,d), h(1:nt-d)*A],'-r', ...
      t*fh, y(1:nt), '-b')
xlabel('Time [ms]')
