function fig714
%FIG714	Generate Fig.7.1.4.1a,b,c for WBAmps, Part 7.
%
%	Show spectrum analysis and multiplication in frequency domain
%	as a substitute for convolution.

% RXon, 000402

f0=1000;				% frequency denormalization factor ;
N=1024;				% total vector length ;
m=64;					% frequency scaling factor
f=f0*(0:1:N-1)/m;	% frequency vector ;

[z,p]=bestap(5,'n');	% 5rd-order Bessel system ;
p=p*2*pi*f0;				% half-power bandwidth is 1kHz ;
F=freqw(z,p,2*pi*f);	% frequency response ;

% dt=2*pi*m/N;		% delta-t ;
dt=m/(f0*N);		% delta-t ;
t=dt*(0:1:N-1);	% time vector ;

% T1=67*dt;			% input signal exponential grow time ;
T2=35*dt;			% input signal exponential decay time ;
f1=1/(16*dt);	% input signal frequency ;
% g=((1-exp(-t/T1)).^2).*exp(-t/T2).*sin(w1*t);	% input function in time domain ;
g=exp(-t/T2).*sin(2*pi*f1*t);	% input function in time domain ;
% h=hanning(179).';
% g(1:90)=g(1:90).*h(1:90);

% % g=[g(1:N/2) -g(1:N/2)];		% the signal repeats every N/2 with opposite phase ;

% % g=[-g(N/2:-1:1) g(1:N/2)];	% the signal repeats every N/2 with opposite phase ;
% % g=1000*(1-exp(-t/(1570*T))).*g;

% % g=sin(2*pi*t*f1);
% % g=g.*[zeros(1,N/4), hanning(N/4).', zeros(1,N/2)];

% ta je OK !!!
% g=g.*[hanning(7*15).', zeros(1,N-7*15)];

g=[zeros(1,N/8), g(1:N-N/8)];

figure(1)
x=max(find(t<=0.06));
plot( t(1:x)*f0, g(1:x), '-r' )
xlabel('Time [ms]')
% axis([0, 0.06, -0.15, 0.15]);
% title('Input signal')

G=fft(g);			% G is spectrum of g ;

Y=F.*G;				% output spectrum ;
				% multiplication in frequency equals convolution in time ;

figure(2)
x=max(find(f<=5000));
M=max(abs(G));
plot( f(1:x), abs(F(1:x)), '-g', ...
      f(1:x), abs(G(1:x))/M, '-r', ...
      f(1:x), abs(Y(1:x))/M, '-b' )
xlabel('Frequency [Hz]'), ylabel('Magnitude');
% title('Magnitude Spectra')

y=2*(real(fft(conj(Y)))-1)/N;	% return to time domain and show result ;

figure(3)
a=max(find(t<=0.005));
b=min(find(t>=0.020));
plot( t(a:b)*f0, g(a:b), '-r', t(a:b)*f0, y(a:b), '-b' )
xlabel('Time [ms]')
% axis([0.005, 0.025, -0.15, 0.15]);
% title('Input and Output Signals')

