 % Noise filtering example ;
 % Script.
 % Call :       noiseflt ;
 
 % Author : E.Margan, 1989.1007.
 % No copyright protection applied !
 
 load R.dat			% load the recorded signal from a file "R.dat"
 N=length(R);		% total vector length, N=2048 samples
 Tr=102.4e-6;		% record length 102.4 us
 dt=Tr/N;			% samppling time interval, 50 ns
 t=dt*(0:1:N-1);		% time vector reconstruction
 
 % plot the first 1200 samples of the recorded signal, see Fig.7.1.4a
 plot( t(1:1200), R(1:1200), '-g' )
 xlabel('Time [\mus]')	% input signal, fist 60us
 
 G=fft(R);			% G is spectrum of R, Fast-Fourier-Transformed
 G=G(1:N/2);		% use only up to the Nyquist freq. ( 10 MHz )
 f=(1:1:N/2)/dt;		% frequency vector reconstructed
 
 [z,p]=bestap(5,'n');	% 5rd-order Bessel filter poles
 p=p*2*pi*1e+6;		% half-power bandwidth is 1 MHz
 F=freqw(z,p,2*pi*f);	% filter frequency response
 
 % multiplication in frequency equals convolution in time :
 Y=F.*G;			% output spectrum
 
 x=max(find(f<=8e+6));	% plot spectrum up to 8 MHz
 M=max(abs(G));		% normalize the spectrum to its peak value
 plot( f(1:x), abs(F(1:x)), '-r', ...
       f(1:x), abs(G(1:x))/M, '-g', ...
       f(1:x), abs(Y(1:x))/M, '-b' )
 xlabel('Frequency [MHz]'), ylabel('Normalized Magnitude')
 % see Fig.7.1.4b
 
 y=2*(real(fft(conj(Y)))-1)/(N/2);	% return to time domain
 
 a=max(find(t<=5e-5));
 b=min(find(t>=20e-6));
 plot( t(a:b), g(a:b), '-g', t(a:b), y(a:b), '-b' )
 xlabel('Time [\mus]')	% see Fig.7.1.4c
