function [D,b,N,l]=L1coil(L,d)
% L1COIL   Calculation of coil dimensions and the number of turns
%          required to obtain a specified inductance L, given the
%          wire diameter d. The calculation uses the Nagaoka single
%          layer coil inductance numerical approximation, optimized
%          for the coil shape factor D/b = 2.451 which gives the
%          maximum inductance for a given wire length and simplifies
%          the calculation (Ref.: F.W.Grover, Inductance calculation,
%          Van Nostrand, 1946, reprinted by Instrument Society of
%          America, 1973).
%
%          Function call :    [D,b,N,l]=L1coil(L,d);
%
%          where :     d = wire diameter in mm,
%                      L = inductance in uH (microHenry)
%                      l = total wire length in m
%                      N = total number of turns
%                      b = coil axial length in mm
%                      D = coil diameter in mm

% adapted for Matlab by Erik Margan, Sept. 12, 1987

% coil shape ratio ( R = D/b ) :
R = 2.451 ;

% aditive correction :
x = 0.0223 ;

% total wire length in m :
l = ( L^2 * (d/10) * sqrt(2) / ( R + x ) )^(1/3) ;

% total number of turns
N = sqrt( 1000 * l / ( pi * R * d ) ) ;

% coil axial length in mm :
b = N * d ;

% coil diameter in mm :
D = R * b ;
