function [z,p,k] = cheb1np(n, rp, f3)
%CHEB1NP Chebyshev type I analog lowpass filter prototype.
%	[Z,P,K] = CHEB1NP(N,Rp) returns the zeros, poles, and gain
%	of an N-th order prototype type I Chebyshev analog
%	lowpass filter with Rp decibels of ripple in the passband.
%	Type I Chebyshev filters are maximally flat in the stopband and
%	have the ripple limit frequency at 1Hz.
%	Optionally, [Z,P,K] = CHEB1NP(N,Rp,F3) where F3 is any non-zero
%	input argument, the filter will have its -3dB frequency at 1Hz.
%	
%	See SYSVIEW to plot resuting system functions;
%	See also CHEB1AP.

%	L. Shure 1-13-88
%	(c) Copyright 1988, by The MathWorks, Inc.
%	Normalization to -3dB at f0=1Hz by Erik Margan, 9-14-88.

z=[];
if n==1
	p=-1;
	k=1;	
	return
end
if nargin == 1
	rp=input('Enter allowable pass-band ripple in dB : ');
end

% j = sqrt(-1);
epsilon = sqrt(10^(.1*rp)-1);
mu = asinh(1/epsilon)/n;
p = exp(j*(pi*(1:2:2*n-1)/(2*n) + pi/2)).';

if nargin == 3
	p=tanh(mu)*real(p) + j*imag(p); 		% abs(F(j*1))=-3[dB];
else
	p = sinh(mu)*real(p) + j*cosh(mu)*imag(p);	% abs(F(j*1))=-Rp[dB];
end

k = real(prod(-p));
if ~rem(n,2)	% n is even so patch k
	k = k/sqrt((1 + epsilon^2));
end
