function [c,u]=constant(str)
% CONSTANT  ...returns a list of some physical constants.
%           A constant's name in the form of input string can be used
%           to get the value and units of that constant.
%
%           Call :   [c,u]=constant(['constant name'])

% Experimental.
% by RXon *980814*

L=0;
if ~nargin
	L = 1 ;
	str = ['list'] ;
end

if strcmp( str, 'list' )
	L = 1 ;
end

if L
	disp(' ')
	disp('Call :	[ value, units_string ] = constant( [''constantname''] ) ;' )
	disp(' ' )
	disp('description : symbol = value  [units]')
	disp('----------------------------------------------')
end

if strcmp( str, ['dielectric'] ) | strcmp( str, ['eps0'] ) | L
	c = 1/(4*pi*8987554647.43) ;  % [As/Vm]
	u = ['[As/Vm]'] ;
	if L
		disp( ['dielectric permitivity of free space :  eps0 = ', num2str(c), ' ', u] )
	end
end

if strcmp( str, ['magnetic'] ) | strcmp( str, ['mu0'] ) | L
	c = 4*pi*1e-7 ;  % [Vs/Am]
	u = ['[Vs/Am]'] ;
	if L
		disp( [' magnetic permeability of free space :   mu0 = ', num2str(c), ' ', u] )
	end
end

if strcmp( str, ['speed'] ) | strcmp( str, ['light'] ) | strcmp( str, ['c'] ) | L
	c = 2.99792458e+8 ;  % [m/s]
	u = ['[m/s]'] ;
	if L
		disp( ['            speed of light in vacuum :     c = ', num2str(c), ' ', u] )
	end
end

if strcmp( str, ['charge_electron'] ) | strcmp( str, ['qe'] ) | L
	c = -1.602e-19 ;  % [As]
	u = ['[As]'] ;
	if L
		disp( ['                     electron charge :    qe = ', num2str(c), ' ', u] )
	end
end

if strcmp( str, ['mass_electron'] ) | strcmp( str, ['me'] ) | L
	c = 9.1095e-31 ;  % [kg]
	u = ['[kg]'] ;
	if L
		disp( ['                       electron mass :    me = ', num2str(c), ' ', u] )
	end
end

if strcmp( str, ['Compton'] ) | strcmp( str, ['lamC'] ) | L
	c = 2.4e-12 ;  % [m]
	u = ['[m]'] ;
	if L
		disp( ['  electron Compton wave-length, h/mc :  lamC = ', num2str(c), ' ', u] )
	end
end

if strcmp( str, ['mass_atom'] ) | strcmp( str, ['ma'] ) | L
	c = 1.661e-27 ;  % [kg]
	u = ['[kg]'] ;
	if L
		disp( ['             atom mass, 1/12 of C-12 :    ma = ', num2str(c), ' ', u] )
	end
end

if strcmp( str, ['Bohr_r'] ) | strcmp( str, ['rB'] ) | L
	c = 52.8e-12 ;  % [m]
	u = ['[m]'] ;
	if L
		disp( ['    Bohr radius for ground_sate of H :    rB = ', num2str(c), ' ', u] )
	end
end

if strcmp( str, ['ionization_e'] ) | strcmp( str, ['W1'] ) | L
	c = 13.6 ;  % [eV]
	u = ['[eV]'] ;
	if L
		disp( ['  ground_sate ionization energy of H :    W1 = ', num2str(c), ' ', u] )
	end
end

if strcmp( str, ['gravity'] ) | strcmp( str, ['G'] ) | L
	c = 6.672e-11 ;  % [Nm^2/kg^2]
	u = ['[Nm^2/kg^2]'] ;
	if L
		disp( ['            general gravity constant :     G = ', num2str(c), ' ', u] )
	end
end

if strcmp( str, ['Boltzmann'] ) | strcmp( str, ['kB'] ) | L
	c = 1.38e-23 ;  % [VAs/K]
	u = ['[VAs/K]'] ;
	if L
		disp( ['                  Boltzmann constant :    kB = ', num2str(c), ' ', u] )
	end
end

if strcmp( str, ['Planck'] ) | strcmp( str, ['h'] ) | L
	c = 6.62e-34 ;  % [Js]
	u = ['[Js]'] ;
	if L
		disp( ['                     Planck constant :     h = ', num2str(c), ' ', u] )
	end
end

if strcmp( str, ['Avogadro'] ) | strcmp( str, ['Na'] ) | L
	c = 6.0221e+26 ;  % []
	u = ['[ ]'] ;
	if L
		disp( ['                     Avogadro number :    Na = ', num2str(c), ' ', u] )
	end
end

if strcmp( str, ['gas'] ) | strcmp( str, ['R'] ) | L
	c = 8313 ;  % [J/kg]
	u = ['[J/kg]'] ;
	if L
		disp( ['                general gas constant :     R = ', num2str(c), ' ', u] )
	end
end

if strcmp( str, ['Ludolf'] ) | strcmp( str, ['pi'] ) | L
	c = pi ;  % []
	u = ['[ ]'] ;
	if L
		disp( ['Ludolf number (circumference/radius) :    pi = ', num2str(c), ' ', u] )
	end
end

if strcmp( str, ['Euler'] ) | strcmp( str, ['e'] ) | L
	c = exp(1) ;  % []
	u = ['[ ]'] ;
	if L
		disp( ['    Euler number (natural log basis) :     e = ', num2str(c), ' ', u] )
	end
end

if strcmp( str, ['eV'] ) | L
	c = 1.602e-19 ;  % [J]
	u = ['[J]'] ;
	if L
		disp( ['     electron-volt equivalent energy :     e = ', num2str(c), ' ', u] )
	end
end
if L
	disp('----------------------------------------------')
	disp(' ')
	c = [] ;
	u = [] ;
end
