function f=cutoff(z,p)
% CUTOFF	returns the system cutoff frequency
%			(the upper half-power limit).
%			Call :
%					f=cutoff(z,p);
%			where	z are the system zeros
%			  and	p are the system poles

% RXon, 011221

n=length(p);
% m=length(z);
wb=real(prod(-p)^(1/n));
wa=1/wb;
f=sqrt(wa*wb);
F=abs(freqw(z,p,f));
a=1/sqrt(2);
while abs(F-a)>0.00001
	f=f*sqrt(F/a);
	F=abs(freqw(z,p,f));
end
