% ESTIMATION OF 1ST ORDER DISCRETE CONTROLLED SYSTEM
% Remark: Two-valued data (1,2), one-step memory model with 
%         control variable, estimation of probabilities of conditional 
%         output
%
%
% designed : IN
% updated  : MK October, 2004
% projects : GACR 102/03/0049, AVCR S1075351, 1ET100750401,
%            MINERVA 110330-CP-1-2003-1-ES-MINERVA-M

prodini, echo off
idef=[];
while 1 % ============================================

if isempty(idef)
  % definitions and initial values
  ndat = 1000;                           % number of data records
  th1 = [.7 .1 .3 .6];                   % probs of y(1|.)=1
  V0=ones(4,2)*1;                        % prior statistics
  y=zeros(1,ndat); u=y;                  % I/O variables
  y1=1;                                  % initial output
  iugn=5;                                % input generator 
end

clc
fprintf('\n ESTIMATION OF 1ST ORDER DISCRETE CONTROLLED SYSTEM');
fprintf('\n ==================================================\n');
%fprintf('\nInput variables\n');
fprintf('--- System --------------------------------\n');
fprintf('Number of data records ->   ndat  = %i;\n',  ndat);
fprintf('Parameters             ->   th1   = \n');   disp(th1);
fprintf('----Initial conditions---------------------\n');
fprintf('initial y              ->   y1    = %g;\n',  y1);
fprintf('initial statistics     ->   V0    =         \n');
fprintf('                               y(t)=1   y(t)=2\n')
fprintf('             u(t)=1  y(t-1)=1     %g     %g\n',V0(1,:))
fprintf('             u(t)=1  y(t-1)=2     %g     %g\n',V0(2,:))
fprintf('             u(t)=2  y(t-1)=1     %g     %g\n',V0(3,:))
fprintf('             u(t)=2  y(t-1)=2     %g     %g\n',V0(4,:))
fprintf('-------------------------------------------\n');

dial1

% errors
while 1;
hlp=[''];
[t1,th1]  = test01(th1, 'th1',1,4);
[t2,V0]   = testint(V0,  'V0',4,2);
[t3,ndat] = testint(ndat,  'ndat',1,1);
[t4,y1]   = testsv(y1,'y1',1,1,[1 2]);
[t5,iugn] = testsv(iugn,'iugn',1,1,[1:5]);
if t1&t2&t3&t4&t5;
   break;
end;
    
fprintf('\n\nEnter valid inputs for:\n');
if ~t1, th1=input(' th1 = '); end
if ~t2,V0=input(' V0 = '); end
if ~t3, ndat=input(' ndat = '); end
if ~t4, y1=input(' y1 = '); end
if ~t5, iugn=input(' iugn = '); end

end

% computed variables
th  = [th1' 1-th1'];                   % complete parameter       
eth = [];


y(1)=y1; V=V0;

% **************************************************************
% loop of simulation and estimation
for t=2:ndat
  % simulation
  u(t)=dpugn(iugn,y(t-1));    % control variable
  y(t)=dpsim(u(t),y(t-1),th); % output generation

  % update statistics
  [V,et]=dpsta(y(t),u(t),y(t-1),V);
  eth=[eth et(:,1)];          % all estimates in time
end
the=[eth(:,ndat-1) ones(4,1)-eth(:,ndat-1)]; % final estimates

% plot
th1S=['th1(1) = ' num2str(th1(1))];
th2S=['th1(2) = ' num2str(th1(2))];
th3S=['th1(3) = ' num2str(th1(3))];
th4S=['th1(4) = ' num2str(th1(4))];
n2=[2 ndat]; o2=ones(size(n2));
resizefig(60,20,20); 
plot(eth')
title('Evolution of parameter point estimates in time',...
  'FontWeight','bold');
xlabel('time','HorizontalAlignment','left');
ylabel('estimates of parameter "th1"');
legend('th1(1)=','2','3','4',-1);
axis([1 ndat 0 1]);
hold on
plot(n2,th1(1)*o2,':',n2,th1(2)*o2,':',n2,th1(3)*o2,':',n2,th1(4)*o2,':')
legend('estimate of th1(1)','estimate of th1(2)','estimate of th1(3)',...
    'estimate of th1(4)',th1S,th2S,th3S,th4S,-1);

hold off
% **************************************************************

dial2
end % ==========================================================
