% d81Con.m
%
% designed : IN
% updated  : JiH, MK October, 2004
% projects : GACR 102/03/0049, AVCR S1075351, 1ET100750401,
%            MDCR 1F43A/003/120, MINERVA 110330-CP-1-2003-1-ES-MINERVA-M

% OPTIMAL CONTROL OF 1ST ORDER DISCRETE CONTROLLED SYSTEM
% Remark: Two-valued data (1,2), one-step memory model
%
% Design   : I. Nagy
% Updated  : July 2004, MK October 2004 
% Projects : GACR 102/03/0049, AVCR S1075351, 1ET100750401, Edukalibre

prodini, echo off
idef=[];
while 1 % ============================================

% definitions and initial values
if isempty(idef)
  ndat = 50;                             % number of data records
  th1 = [.7 .1 .3 .6];                   % probs of y(1|.)=1
  z = [0 0 1 1; 5 5 6 6]';               % loss function
  y0=1;                                  % initial output
end
Krit = 0;                                % criterion
th1=th1(:)';

clc
fprintf('\n OPTIMAL CONTROL OF 1ST ORDER DISCRETE CONTROLLED SYSTEM');
fprintf('\n =======================================================\n');
%fprintf('\n Input variables\n');
fprintf('\n--- System ------------------------------------\n');
fprintf('Number of data records          ->  ndat  = %i;\n',  ndat);
fprintf('Initial y                       ->  y0    = %g;\n',  y0);
fprintf('Parameters                      ->  th1   = %g %g %g %g;\n',th1);  
disp(' determining transition probabilities  th    =')
disp('                            y(t)=1   y(t)=2 ');   
disp('       u(t)=1  y(t-1)=1     th1(1)   1-th1(1)')
disp('       u(t)=1  y(t-1)=2     th1(2)   1-th1(1)')
disp('       u(t)=2  y(t-1)=1     th1(3)   1-th1(1)')
disp('       u(t)=2  y(t-1)=2     th1(4)   1-th1(1)')
fprintf('\n--- Loss function -----------------------------\n');
fprintf('Partial loss                    ->  z     = \n');
fprintf('                           y(t)=1  y(t)=2 \n');   
fprintf('       u(t)=1  y(t-1)=1       %g       %g\n',z(1,:)')
fprintf('       u(t)=1  y(t-1)=2       %g       %g\n',z(2,:)')
fprintf('       u(t)=2  y(t-1)=1       %g       %g\n',z(3,:)')
fprintf('       u(t)=2  y(t-1)=2       %g       %g\n',z(4,:)')
fprintf('-------------------------------------------------\n');

dial1

% errors
while 1;
hlp=[''];
[t1,ndat] = testint(ndat,'ndat', 1,1); 
[t2,y0]   = testsv(y0,'y0',1,1,[1 2]);
[t3,th1]  = test01(th1,'th1', 1,4);
[t4,z]    = testneg(z,'z',4,2);
if t1&t2&t3&t4;
   break;
end;
    
fprintf('\n\n');
fprintf('\n\nEnter valid inputs for %s:\n',hlp);

if ~t1, ndat=input(' ndat = '); end
if ~t2, y0=input(' y0 = '); end
if ~t3, th1=input(' th1 = '); end
if ~t4, z=input(' z = '); end

end

% computed variables
th1=colv(th1);
th  = [th1 1-th1];                     % complete parameter       

% definitions
y = zeros(1,ndat); y(1)=y0; u=y;       % I/O variables
Vs = zeros(ndat+1,2);                  % Bellman function
us = zeros(ndat,2);                    % optimal control

% **************************************************************
% computation of optimal control law
for t=ndat:-1:2
  [Vs(t,:) us(t,:)]=dpbel(z,Vs(t+1,:),th);
end

% application of optimal control law
for t=2:ndat
  u(t)=us(t,y(t-1));                   % optimal control
  y(t)=dpsim(u(t),y(t-1),th);          % output generation
end

kr = dpkri(2:ndat,y,u,z);
fprintf('     The achieved loss is:   %g;\n\n',kr)

resizefig(60,20,20); 
plot(1:ndat,y(1:ndat),'+',2:ndat,u(2:ndat),'o','markersize',5)
title('Multi-step control of discrete system','FontWeight','bold')
xlabel('time','HorizontalAlignment','left');
ylabel('inpts & outputs');
legend(' input','output',-1);
axis([0,ndat+1,1-.2,2.2])  
% **************************************************************

dial2
end % ==========================================================
