function [VV,uu]=dpbel(z,Vs,th)
% [VV,uu]=dpbel(z,Vs,th)
% update of the Bellman function
%
% VV  value of minimal criterion
% uu  optimal control strategy
% z   loss function
% Vs  minimized criterion from last step
% th  model parameters
%
for u=1:2
  for y1=1:2
    i=2*u+y1-2;
    v1=(z(i,1)+Vs(1))*th(i,1);
    v2=(z(i,2)+Vs(2))*th(i,2);
    V(u,y1)=v1+v2;
  end
end
[VV uu]=min(V);
