function [S,Eth]=dpsta(y,u,y1,S)
% [S,Eth]=dpsta(y,u,y1,S)
% binary statistics recomputation
%
% S   statistics
% Eth estimate of parameters
% y   output
% u   input
% y1  old output
%
  i=index([u y1]);                     % index of regression vector
  S(i,y)=S(i,y)+1;                     % recomputation of statistics
  th1=S(:,1)./(S(:,1)+S(:,2));         % parameter estimate
  Eth=[th1 1-th1];                     % full parameter matrix
