function ind=index(psi,b)
% ind=index(psi,b)
% generation of (binary) index of vector psi
%
% ind   generated index (order of permutations from right) 
%       1 1 -> 1; 1 2 -> 2; 2 1 -> 3; 2 2 -> 4 etc.
% psi   regression vector (composed of 1, 2 (3, ...))
% b     basis (default 2, variables coded by 1 and 2)
%       b={[1 2] [0 1 2]} means, that first variable in psi is
%         coded by  1 2  and second by  0 1 2.
%       b=[0 1] means, that all variables are coded by  0 1.
%
n=length(psi);
if nargin<2, 
  ind=0;
  for i=1:n
    ind=2*ind+psi(i)-1;
  end
  ind=ind+1;
else
  ind=0;
  psj=zeros(n);
  for i=1:n
    if iscell(b), z=b{i};
    else          z=b; end
    nz=length(z);
    [m psj(i)]=max(psi(i)==z);
    ind=nz*ind+psj(i)-1;
  end
  ind=ind+1;
end