function [Fac, Res, pH0s] = bisect(Fac0, n, flag)
% estimate length of learning segment  
% [Fac, Res] = bisect(Fac0, n)
%
% Fac0: initial factor
% n   : number of segments
% flag: 0 or 1 => debugging display
%
% Fac : factor estimated with whole data | Fac0
% Res : structure with fields
%   ok  : hypothesis H0 is accepted
%   pH0 : probability of H0
%   tl,tu,pl,pu : low and high time and statistics
% pH0s: probability of H0 as a function of cutting moments
%
% Updated  : September 2004
% Project: GA CR 102/03/0049, AV CR S1075351, S1075102, DESIGNER


global DATA TIME
if nargin<3, flag=0; end
data   = DATA;
ndat   = length(DATA);
Mix0   = mixconst(Fac0, 1, 1);                           
maxtd  = mixmaxtd(Mix0);
ndat0  = floor((ndat-maxtd)/n)+1;
tsec   = maxtd+1:ndat0:ndat;
if tsec(length(tsec))<ndat-1
    tsec = [tsec, ndat];
end

% accumulation of data increments of statistics and learning parts of statistics
nchn = length(DATA);
% learning data
vlll = [];
Facls = cell(1,n); 

Mix  = Mix0;
for i=1:n
     
     for TIME=tsec(i):tsec(i+1)-1
         Mix= mixestim(Mix, 1);    
     end   
        
     vlll     = [vlll,facvll(Mix.Facs{1},Fac0)]; 
     Facls{i} = Mix.Facs{1};   
end
Fac = Mix.Facs{1};

% validation data
vllv  = [];
for i=1:n
     ndatl =i*ndat0;
     DATA = data(:,tsec(i+1):ndat);

     r    = Fac0.dfm/Facls{i}.dfm;
     Mixp = mixconst(facflat(Facls{i},r),1,1); 
  if size(DATA,2)>maxtd+2
     Mix  = mixestim(Mixp, 1, length(DATA));            
  end    
     vllv = [vllv,facvll(Mix.Facs{1},Mixp.Facs{1})];
end


% validation
tl = 0;
tu = n;
pl = 0.5;
pu = 0.5;
 
pH0s     = [];
C = [ ];
for i=1:n
      C   = [C,facvll(Facls{n}, Fac0)];                
    pH0   = 1/ (  1 +  exp (vlll(i)+vllv(i)-C(i)));
if flag
    pH0s  = [pH0s,[vlll(i),vllv(i),C(i),vlll(i)+vllv(i)-C(i),pH0]'];  
    if flag,fprintf('vll1=%g  vllv=%g C=%g  vlll+vllv-C=%g  pH0=%g\n',...
         vlll(i), vllv(i), C(i), vlll(i)+vllv(i)-C(i), pH0);
    end
else pH0s = [pH0s, pH0];
end
    if     pH0 > pu, pu = pH0; tu = i;
    elseif pH0 < pl, pl = pH0; tl=i;
    end

end

if pu>1-pl, ok=1;
else        ok=0;
end

 
Res.ok = ok;
Res.tl=tl;
Res.tu=tu;
Res.pl=pl;
Res.pu=pu;
DATA = data;
